/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.commands;

import com.playtimerewards.PlaytimeRewards;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TabCompleter
implements org.bukkit.command.TabCompleter {
    private final PlaytimeRewards plugin;
    private static final List<String> SUBCOMMANDS = Arrays.asList("reload", "time", "add");

    public TabCompleter(PlaytimeRewards plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            for (String subcommand : SUBCOMMANDS) {
                if (!subcommand.startsWith(input) || subcommand.equals("reload") && !sender.hasPermission("playtimerewards.reload") || subcommand.equals("time") && !sender.hasPermission("playtimerewards.time.others") && !(sender instanceof Player) || subcommand.equals("add") && !sender.hasPermission("playtimerewards.add")) continue;
                completions.add(subcommand);
            }
        } else if (args.length == 2) {
            String subcommand = args[0].toLowerCase();
            String input = args[1].toLowerCase();
            if (subcommand.equals("time")) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList()));
            } else if (subcommand.equals("add") && sender.hasPermission("playtimerewards.add")) {
                if ("60".startsWith(input)) {
                    completions.add("60");
                }
                if ("300".startsWith(input)) {
                    completions.add("300");
                }
                if ("720".startsWith(input)) {
                    completions.add("720");
                }
                if ("1440".startsWith(input)) {
                    completions.add("1440");
                }
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("add")) {
            String input = args[2].toLowerCase();
            if (sender.hasPermission("playtimerewards.add")) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList()));
            }
        }
        return completions;
    }
}

