/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.gui;

import com.playtimerewards.PlaytimeRewards;
import com.playtimerewards.managers.DataManager;
import com.playtimerewards.managers.LanguageManager;
import com.playtimerewards.managers.RewardManager;
import com.playtimerewards.models.RewardMilestone;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RewardsGUI {
    private final PlaytimeRewards plugin;
    private final Player player;
    private final UUID playerUUID;
    private final LanguageManager languageManager;
    private final RewardManager rewardManager;
    private final DataManager dataManager;

    public RewardsGUI(PlaytimeRewards plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.playerUUID = player.getUniqueId();
        this.languageManager = plugin.getLanguageManager();
        this.rewardManager = plugin.getRewardManager();
        this.dataManager = plugin.getDataManager();
    }

    public void openGUI() {
        int guiSize = this.plugin.getConfigManager().getGUISize();
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigManager().getGUITitle());
        Inventory gui = Bukkit.createInventory(null, (int)guiSize, (String)title);
        this.fillBackground(gui);
        this.addRewardItems(gui);
        this.player.openInventory(gui);
    }

    private void fillBackground(Inventory gui) {
        Material material;
        String fillMaterial = this.plugin.getConfigManager().getFillItemMaterial();
        String fillName = this.plugin.getConfigManager().getFillItemName();
        try {
            material = Material.valueOf((String)fillMaterial.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            material = Material.GRAY_STAINED_GLASS_PANE;
            this.plugin.getLogger().warning("Invalid fill material: " + fillMaterial);
        }
        ItemStack fillItem = new ItemStack(material);
        ItemMeta meta = fillItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)fillName));
            fillItem.setItemMeta(meta);
        }
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, fillItem);
        }
    }

    private void addRewardItems(Inventory gui) {
        int playerPlaytime = this.dataManager.getPlayerPlaytime(this.playerUUID);
        Map<String, RewardMilestone> rewards = this.rewardManager.getAllRewards();
        for (RewardMilestone reward : rewards.values()) {
            ItemStack rewardItem = this.createRewardItem(reward, playerPlaytime);
            if (reward.getSlot() >= 0 && reward.getSlot() < gui.getSize()) {
                gui.setItem(reward.getSlot(), rewardItem);
                continue;
            }
            this.plugin.getLogger().warning("Reward " + reward.getId() + " has invalid slot: " + reward.getSlot());
        }
    }

    private ItemStack createRewardItem(RewardMilestone reward, int playerPlaytime) {
        boolean isClaimed = this.dataManager.hasClaimedReward(this.playerUUID, reward.getId());
        boolean isUnlocked = playerPlaytime >= reward.getTimeMinutes();
        RewardMilestone.ItemIcon icon = isClaimed && reward.getClaimedIcon() != null ? reward.getClaimedIcon() : reward.getIcon();
        ItemStack item = new ItemStack(icon.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)icon.getName());
            meta.setDisplayName(displayName);
            List<String> lore = this.createRewardLore(reward, icon, playerPlaytime, isUnlocked, isClaimed);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private List<String> createRewardLore(RewardMilestone reward, RewardMilestone.ItemIcon icon, int playerPlaytime, boolean isUnlocked, boolean isClaimed) {
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : icon.getLore()) {
            String processedLine = this.processLoreLine(line, reward, playerPlaytime, isUnlocked, isClaimed);
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)processedLine));
        }
        return lore;
    }

    private String processLoreLine(String line, RewardMilestone reward, int playerPlaytime, boolean isUnlocked, boolean isClaimed) {
        String processedLine = line;
        if (processedLine.contains("%status%")) {
            String status = isClaimed ? this.languageManager.getMessage((CommandSender)this.player, "gui.status_claimed") : (isUnlocked ? this.languageManager.getMessage((CommandSender)this.player, "gui.status_available") : this.languageManager.getMessage((CommandSender)this.player, "gui.status_locked"));
            processedLine = processedLine.replace("%status%", status);
        }
        if (processedLine.contains("%time%") && !isUnlocked) {
            int timeNeeded = reward.getTimeMinutes() - playerPlaytime;
            String timeFormatted = this.languageManager.formatTime((CommandSender)this.player, timeNeeded);
            processedLine = processedLine.replace("%time%", timeFormatted);
        }
        processedLine = processedLine.replace("%player%", this.player.getName());
        return processedLine;
    }

    public void handleRewardClick(String rewardId) {
        boolean isUnlocked;
        RewardMilestone reward = this.rewardManager.getReward(rewardId);
        if (reward == null) {
            return;
        }
        int playerPlaytime = this.dataManager.getPlayerPlaytime(this.playerUUID);
        boolean isClaimed = this.dataManager.hasClaimedReward(this.playerUUID, rewardId);
        boolean bl = isUnlocked = playerPlaytime >= reward.getTimeMinutes();
        if (isClaimed) {
            String message = this.languageManager.getMessage((CommandSender)this.player, "gui.reward_already_claimed");
            this.player.sendMessage(message);
            return;
        }
        if (!isUnlocked) {
            int timeNeeded = reward.getTimeMinutes() - playerPlaytime;
            String timeFormatted = this.languageManager.formatTime((CommandSender)this.player, timeNeeded);
            String message = this.languageManager.getMessage((CommandSender)this.player, "gui.reward_not_unlocked").replace("%time%", timeFormatted);
            this.player.sendMessage(message);
            return;
        }
        if (this.plugin.getConfigManager().arePermissionsEnabled() && reward.getPermission() != null && !this.player.hasPermission(reward.getPermission())) {
            String message = this.languageManager.getMessage((CommandSender)this.player, "gui.reward_no_permission");
            this.player.sendMessage(message);
            return;
        }
        this.claimReward(reward);
    }

    private void claimReward(RewardMilestone reward) {
        this.dataManager.claimReward(this.playerUUID, reward.getId());
        this.playClaimSound();
        this.executeRewardCommands(reward);
        this.sendRewardMessages(reward);
        this.sendClaimAnnouncement(reward);
        String successMessage = this.languageManager.getMessage((CommandSender)this.player, "gui.reward_claimed");
        this.player.sendMessage(successMessage);
        this.openGUI();
    }

    private void executeRewardCommands(RewardMilestone reward) {
        for (String command : reward.getCommands()) {
            String processedCommand = command.replace("%player%", this.player.getName());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processedCommand));
        }
    }

    private void sendRewardMessages(RewardMilestone reward) {
        for (String message : reward.getMessages()) {
            String processedMessage = message.replace("%player%", this.player.getName());
            String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)processedMessage);
            this.player.sendMessage(coloredMessage);
        }
    }

    private void playClaimSound() {
        if (!this.plugin.getConfigManager().areSoundsEnabled()) {
            return;
        }
        try {
            String soundName = this.plugin.getConfigManager().getClaimSuccessSound();
            Sound sound = Sound.valueOf((String)soundName);
            float volume = this.plugin.getConfigManager().getSoundVolume();
            float pitch = this.plugin.getConfigManager().getSoundPitch();
            this.player.playSound(this.player.getLocation(), sound, volume, pitch);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid sound effect: " + this.plugin.getConfigManager().getClaimSuccessSound());
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.0f);
        }
    }

    private void sendClaimAnnouncement(RewardMilestone reward) {
        if (!this.plugin.getConfigManager().areAnnouncementsEnabled()) {
            return;
        }
        String rewardName = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)reward.getIcon().getName()));
        String announcement = this.plugin.getConfigManager().getAnnouncementMessage().replace("%player%", this.player.getName()).replace("%reward%", rewardName);
        String coloredAnnouncement = ChatColor.translateAlternateColorCodes((char)'&', (String)announcement);
        if (this.plugin.getConfigManager().shouldBroadcastAnnouncements()) {
            Bukkit.broadcastMessage((String)coloredAnnouncement);
        } else {
            this.player.sendMessage(coloredAnnouncement);
        }
    }

    public static boolean isRewardsGUI(Inventory inventory) {
        if (inventory == null || inventory.getHolder() != null) {
            return false;
        }
        int expectedSize = PlaytimeRewards.getInstance().getConfigManager().getGUISize();
        return inventory.getSize() == expectedSize && inventory.getHolder() == null;
    }
}

