/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.listeners;

import com.playtimerewards.PlaytimeRewards;
import com.playtimerewards.gui.RewardsGUI;
import com.playtimerewards.managers.RewardManager;
import com.playtimerewards.models.RewardMilestone;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class InventoryClickListener
implements Listener {
    private final PlaytimeRewards plugin;
    private final RewardManager rewardManager;

    public InventoryClickListener(PlaytimeRewards plugin) {
        this.plugin = plugin;
        this.rewardManager = plugin.getRewardManager();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!RewardsGUI.isRewardsGUI(event.getInventory())) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot < 0 || slot >= event.getInventory().getSize()) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        String rewardId = this.findRewardBySlot(slot);
        if (rewardId == null) {
            return;
        }
        RewardsGUI gui = new RewardsGUI(this.plugin, player);
        gui.handleRewardClick(rewardId);
    }

    private String findRewardBySlot(int slot) {
        for (RewardMilestone reward : this.rewardManager.getAllRewards().values()) {
            if (reward.getSlot() != slot) continue;
            return reward.getId();
        }
        return null;
    }
}

