/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.listeners;

import com.playtimerewards.PlaytimeRewards;
import com.playtimerewards.managers.DataManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerQuitListener
implements Listener {
    private final PlaytimeRewards plugin;
    private final DataManager dataManager;

    public PlayerQuitListener(PlaytimeRewards plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.dataManager.updatePlayerInfo(player);
        this.dataManager.savePlayerData(player.getUniqueId());
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Player " + player.getName() + " quit. Final playtime: " + this.dataManager.getPlayerPlaytime(player.getUniqueId()) + " minutes");
        }
    }
}

