/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.managers;

import com.playtimerewards.PlaytimeRewards;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final PlaytimeRewards plugin;
    private FileConfiguration config;

    public ConfigManager(PlaytimeRewards plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.validateConfig();
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    private void validateConfig() {
        int guiSize;
        if (!this.config.contains("language")) {
            this.plugin.getLogger().warning("Missing 'language' section in config.yml");
        }
        if (!this.config.contains("gui")) {
            this.plugin.getLogger().warning("Missing 'gui' section in config.yml");
        }
        if (!this.config.contains("rewards")) {
            this.plugin.getLogger().warning("Missing 'rewards' section in config.yml");
        }
        if ((guiSize = this.getGUISize()) % 9 != 0 || guiSize < 9 || guiSize > 54) {
            this.plugin.getLogger().warning("Invalid GUI size: " + guiSize + ". Must be multiple of 9 between 9-54");
        }
        int saveInterval = this.getSaveInterval();
        int incrementInterval = this.getIncrementInterval();
        if (saveInterval < 1) {
            this.plugin.getLogger().warning("Save interval too low: " + saveInterval + " minutes. Using 5 minutes instead.");
        }
        if (incrementInterval < 30) {
            this.plugin.getLogger().warning("Increment interval too low: " + incrementInterval + " seconds. Using 60 seconds instead.");
        }
    }

    public String getDefaultLanguage() {
        return this.config.getString("language.default", "en_US");
    }

    public boolean isPerPlayerLanguageEnabled() {
        return this.config.getBoolean("language.per_player_language", true);
    }

    public String getGUITitle() {
        return this.config.getString("gui.title", "&6&lPlaytime Rewards");
    }

    public int getGUISize() {
        int size = this.config.getInt("gui.size", 54);
        if (size % 9 != 0 || size < 9 || size > 54) {
            return 54;
        }
        return size;
    }

    public String getFillItemMaterial() {
        return this.config.getString("gui.fill_item.material", "GRAY_STAINED_GLASS_PANE");
    }

    public String getFillItemName() {
        return this.config.getString("gui.fill_item.name", " ");
    }

    public int getSaveInterval() {
        return Math.max(1, this.config.getInt("tracking.save_interval", 5));
    }

    public int getIncrementInterval() {
        return Math.max(30, this.config.getInt("tracking.increment_interval", 60));
    }

    public boolean isDebugEnabled() {
        return this.config.getBoolean("debug.enabled", false);
    }

    public boolean shouldLogPlaytimeUpdates() {
        return this.config.getBoolean("debug.log_playtime_updates", false);
    }

    public boolean arePermissionsEnabled() {
        return this.config.getBoolean("permissions.enabled", true);
    }

    public boolean areSoundsEnabled() {
        return this.config.getBoolean("sounds.enabled", true);
    }

    public String getClaimSuccessSound() {
        return this.config.getString("sounds.claim_success", "ENTITY_PLAYER_LEVELUP");
    }

    public float getSoundVolume() {
        return (float)this.config.getDouble("sounds.volume", 0.7);
    }

    public float getSoundPitch() {
        return (float)this.config.getDouble("sounds.pitch", 1.0);
    }

    public boolean areAnnouncementsEnabled() {
        return this.config.getBoolean("announcements.enabled", true);
    }

    public boolean shouldBroadcastAnnouncements() {
        return this.config.getBoolean("announcements.broadcast", true);
    }

    public String getAnnouncementMessage() {
        return this.config.getString("announcements.message", "&6&l[PlaytimeRewards] &a%player% &7has claimed the &b%reward% &7reward!");
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void saveConfig() {
        this.plugin.saveConfig();
    }
}

