/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.managers;

import com.playtimerewards.PlaytimeRewards;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LanguageManager {
    private final PlaytimeRewards plugin;
    private final Map<String, FileConfiguration> languageFiles;
    private final String[] supportedLanguages = new String[]{"en_US", "hr_HR", "de_DE", "es_ES", "pt_PT", "zh_CN"};

    public LanguageManager(PlaytimeRewards plugin) {
        this.plugin = plugin;
        this.languageFiles = new HashMap<String, FileConfiguration>();
        this.loadLanguages();
    }

    public void loadLanguages() {
        this.languageFiles.clear();
        File languagesDir = new File(this.plugin.getDataFolder(), "languages");
        if (!languagesDir.exists()) {
            languagesDir.mkdirs();
        }
        for (String language : this.supportedLanguages) {
            this.loadLanguageFile(language);
        }
        this.plugin.getLogger().info("Loaded " + this.languageFiles.size() + " language files");
    }

    private void loadLanguageFile(String language) {
        File languageFile = new File(this.plugin.getDataFolder(), "languages/" + language + ".yml");
        if (!languageFile.exists()) {
            try {
                InputStream resource = this.plugin.getResource("languages/" + language + ".yml");
                if (resource != null) {
                    Files.copy(resource, languageFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to extract language file: " + language + ".yml");
                e.printStackTrace();
                return;
            }
        }
        try {
            YamlConfiguration langConfig = YamlConfiguration.loadConfiguration((File)languageFile);
            this.languageFiles.put(language, (FileConfiguration)langConfig);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Loaded language file: " + language + ".yml");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load language file: " + language + ".yml");
            e.printStackTrace();
        }
    }

    public void reloadLanguages() {
        this.loadLanguages();
    }

    public String getMessage(CommandSender sender, String key) {
        return this.getMessage(sender, key, null);
    }

    public String getMessage(CommandSender sender, String key, String defaultMessage) {
        String language = this.getPlayerLanguage(sender);
        return this.getMessage(language, key, defaultMessage);
    }

    public String getMessage(String language, String key, String defaultMessage) {
        FileConfiguration langConfig = this.languageFiles.get(language);
        if (langConfig == null) {
            language = this.getDefaultLanguage();
            langConfig = this.languageFiles.get(language);
        }
        if (langConfig == null) {
            langConfig = this.languageFiles.get("en_US");
        }
        if (langConfig == null) {
            return defaultMessage != null ? defaultMessage : key;
        }
        String message = langConfig.getString(key, defaultMessage != null ? defaultMessage : key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String getPlayerLanguage(CommandSender sender) {
        if (sender instanceof Player && this.plugin.getConfigManager().isPerPlayerLanguageEnabled()) {
            Player player = (Player)sender;
            String playerLang = this.plugin.getDataManager().getPlayerLanguage(player.getUniqueId());
            if (playerLang != null && this.languageFiles.containsKey(playerLang)) {
                return playerLang;
            }
        }
        return this.getDefaultLanguage();
    }

    public String getDefaultLanguage() {
        return this.plugin.getConfigManager().getDefaultLanguage();
    }

    public void setPlayerLanguage(Player player, String language) {
        if (this.languageFiles.containsKey(language)) {
            this.plugin.getDataManager().setPlayerLanguage(player.getUniqueId(), language);
        }
    }

    public boolean isLanguageSupported(String language) {
        return this.languageFiles.containsKey(language);
    }

    public String[] getSupportedLanguages() {
        return (String[])this.supportedLanguages.clone();
    }

    public String formatTime(CommandSender sender, int minutes) {
        int hours = minutes / 60;
        int remainingMinutes = minutes % 60;
        int days = hours / 24;
        int remainingHours = hours % 24;
        StringBuilder timeStr = new StringBuilder();
        if (days > 0) {
            String dayUnit = days == 1 ? this.getMessage(sender, "time.days") : this.getMessage(sender, "time.days_plural");
            timeStr.append(days).append(" ").append(dayUnit);
            if (remainingHours > 0 || remainingMinutes > 0) {
                timeStr.append(" ");
            }
        }
        if (remainingHours > 0) {
            String hourUnit = remainingHours == 1 ? this.getMessage(sender, "time.hours") : this.getMessage(sender, "time.hours_plural");
            timeStr.append(remainingHours).append(" ").append(hourUnit);
            if (remainingMinutes > 0) {
                timeStr.append(" ");
            }
        }
        if (remainingMinutes > 0 || timeStr.length() == 0) {
            String minuteUnit = remainingMinutes == 1 ? this.getMessage(sender, "time.minutes") : this.getMessage(sender, "time.minutes_plural");
            timeStr.append(remainingMinutes).append(" ").append(minuteUnit);
        }
        return timeStr.toString();
    }
}

