/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.managers;

import com.playtimerewards.PlaytimeRewards;
import com.playtimerewards.models.RewardMilestone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class RewardManager {
    private final PlaytimeRewards plugin;
    private final Map<String, RewardMilestone> rewards;
    private final List<RewardMilestone> sortedRewards;

    public RewardManager(PlaytimeRewards plugin) {
        this.plugin = plugin;
        this.rewards = new HashMap<String, RewardMilestone>();
        this.sortedRewards = new ArrayList<RewardMilestone>();
        this.loadRewards();
    }

    public void loadRewards() {
        this.rewards.clear();
        this.sortedRewards.clear();
        ConfigurationSection rewardsSection = this.plugin.getConfigManager().getConfig().getConfigurationSection("rewards");
        if (rewardsSection == null) {
            this.plugin.getLogger().warning("No rewards configured in config.yml!");
            return;
        }
        int validRewards = 0;
        int invalidRewards = 0;
        for (String rewardId : rewardsSection.getKeys(false)) {
            ConfigurationSection rewardSection = rewardsSection.getConfigurationSection(rewardId);
            if (rewardSection == null) {
                this.plugin.getLogger().warning("Invalid reward configuration for: " + rewardId);
                ++invalidRewards;
                continue;
            }
            try {
                RewardMilestone milestone = this.loadRewardMilestone(rewardId, rewardSection);
                if (milestone != null) {
                    this.rewards.put(rewardId, milestone);
                    this.sortedRewards.add(milestone);
                    ++validRewards;
                    continue;
                }
                ++invalidRewards;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load reward " + rewardId + ": " + e.getMessage());
                ++invalidRewards;
            }
        }
        this.sortedRewards.sort(Comparator.comparingInt(RewardMilestone::getTimeMinutes));
        this.plugin.getLogger().info("Loaded " + validRewards + " valid rewards" + (String)(invalidRewards > 0 ? " (" + invalidRewards + " invalid)" : ""));
    }

    private RewardMilestone loadRewardMilestone(String id, ConfigurationSection section) {
        int timeMinutes = section.getInt("time_minutes", -1);
        int slot = section.getInt("slot", -1);
        if (timeMinutes <= 0) {
            this.plugin.getLogger().warning("Invalid time_minutes for reward " + id + ": " + timeMinutes);
            return null;
        }
        if (slot < 0) {
            this.plugin.getLogger().warning("Invalid slot for reward " + id + ": " + slot);
            return null;
        }
        int guiSize = this.plugin.getConfigManager().getGUISize();
        if (slot >= guiSize) {
            this.plugin.getLogger().warning("Slot " + slot + " for reward " + id + " is outside GUI size (" + guiSize + ")");
            return null;
        }
        ConfigurationSection iconSection = section.getConfigurationSection("icon");
        if (iconSection == null) {
            this.plugin.getLogger().warning("Missing icon configuration for reward: " + id);
            return null;
        }
        RewardMilestone.ItemIcon icon = this.loadItemIcon(iconSection);
        if (icon == null) {
            this.plugin.getLogger().warning("Invalid icon configuration for reward: " + id);
            return null;
        }
        ConfigurationSection claimedIconSection = section.getConfigurationSection("claimed_icon");
        RewardMilestone.ItemIcon claimedIcon = null;
        if (claimedIconSection != null) {
            claimedIcon = this.loadItemIcon(claimedIconSection);
        }
        List commands = section.getStringList("commands");
        List messages = section.getStringList("messages");
        String permission = section.getString("permission", null);
        return new RewardMilestone(id, timeMinutes, slot, icon, claimedIcon, commands, messages, permission);
    }

    private RewardMilestone.ItemIcon loadItemIcon(ConfigurationSection section) {
        Material material;
        String materialName = section.getString("material");
        if (materialName == null) {
            return null;
        }
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid material: " + materialName);
            return null;
        }
        String name = section.getString("name", "");
        List lore = section.getStringList("lore");
        return new RewardMilestone.ItemIcon(material, name, lore);
    }

    public void reloadRewards() {
        this.loadRewards();
    }

    public RewardMilestone getReward(String id) {
        return this.rewards.get(id);
    }

    public Map<String, RewardMilestone> getAllRewards() {
        return new HashMap<String, RewardMilestone>(this.rewards);
    }

    public List<RewardMilestone> getSortedRewards() {
        return new ArrayList<RewardMilestone>(this.sortedRewards);
    }

    public List<RewardMilestone> getAvailableRewards(int playerPlaytimeMinutes) {
        ArrayList<RewardMilestone> available = new ArrayList<RewardMilestone>();
        for (RewardMilestone reward : this.sortedRewards) {
            if (playerPlaytimeMinutes < reward.getTimeMinutes()) continue;
            available.add(reward);
        }
        return available;
    }

    public List<RewardMilestone> getLockedRewards(int playerPlaytimeMinutes) {
        ArrayList<RewardMilestone> locked = new ArrayList<RewardMilestone>();
        for (RewardMilestone reward : this.sortedRewards) {
            if (playerPlaytimeMinutes >= reward.getTimeMinutes()) continue;
            locked.add(reward);
        }
        return locked;
    }

    public RewardMilestone getNextReward(int playerPlaytimeMinutes) {
        for (RewardMilestone reward : this.sortedRewards) {
            if (playerPlaytimeMinutes >= reward.getTimeMinutes()) continue;
            return reward;
        }
        return null;
    }

    public boolean hasSlotConflicts() {
        HashSet<Integer> usedSlots = new HashSet<Integer>();
        for (RewardMilestone reward : this.rewards.values()) {
            if (usedSlots.contains(reward.getSlot())) {
                return true;
            }
            usedSlots.add(reward.getSlot());
        }
        return false;
    }

    public List<String> getSlotConflicts() {
        HashMap<Integer, List> slotMap = new HashMap<Integer, List>();
        ArrayList<String> conflicts = new ArrayList<String>();
        for (RewardMilestone rewardMilestone : this.rewards.values()) {
            slotMap.computeIfAbsent(rewardMilestone.getSlot(), k -> new ArrayList()).add(rewardMilestone.getId());
        }
        for (Map.Entry entry : slotMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            conflicts.addAll((Collection)entry.getValue());
        }
        return conflicts;
    }

    public int getRewardCount() {
        return this.rewards.size();
    }

    public boolean rewardExists(String id) {
        return this.rewards.containsKey(id);
    }
}

