/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.models;

import java.util.List;
import org.bukkit.Material;

public class RewardMilestone {
    private final String id;
    private final int timeMinutes;
    private final int slot;
    private final ItemIcon icon;
    private final ItemIcon claimedIcon;
    private final List<String> commands;
    private final List<String> messages;
    private final String permission;

    public RewardMilestone(String id, int timeMinutes, int slot, ItemIcon icon, ItemIcon claimedIcon, List<String> commands, List<String> messages, String permission) {
        this.id = id;
        this.timeMinutes = timeMinutes;
        this.slot = slot;
        this.icon = icon;
        this.claimedIcon = claimedIcon;
        this.commands = commands != null ? commands : List.of();
        this.messages = messages != null ? messages : List.of();
        this.permission = permission;
    }

    public String getId() {
        return this.id;
    }

    public int getTimeMinutes() {
        return this.timeMinutes;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemIcon getIcon() {
        return this.icon;
    }

    public ItemIcon getClaimedIcon() {
        return this.claimedIcon;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasPermission() {
        return this.permission != null && !this.permission.trim().isEmpty();
    }

    public double getTimeHours() {
        return (double)this.timeMinutes / 60.0;
    }

    public double getTimeDays() {
        return (double)this.timeMinutes / 1440.0;
    }

    public String toString() {
        return "RewardMilestone{id='" + this.id + "', timeMinutes=" + this.timeMinutes + ", slot=" + this.slot + "}";
    }

    public static class ItemIcon {
        private final Material material;
        private final String name;
        private final List<String> lore;

        public ItemIcon(Material material, String name, List<String> lore) {
            this.material = material;
            this.name = name != null ? name : "";
            this.lore = lore != null ? lore : List.of();
        }

        public Material getMaterial() {
            return this.material;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getLore() {
            return this.lore;
        }

        public boolean hasCustomName() {
            return !this.name.trim().isEmpty();
        }

        public boolean hasLore() {
            return !this.lore.isEmpty();
        }

        public String toString() {
            return "ItemIcon{material=" + String.valueOf(this.material) + ", name='" + this.name + "', lore=" + this.lore.size() + " lines}";
        }
    }
}

