/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.utils;

import com.playtimerewards.PlaytimeRewards;
import com.playtimerewards.managers.DataManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PlaytimeTracker {
    private final PlaytimeRewards plugin;
    private final DataManager dataManager;
    private BukkitTask incrementTask;
    private BukkitTask saveTask;

    public PlaytimeTracker(PlaytimeRewards plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
    }

    public void startTracking() {
        this.stopTracking();
        this.startIncrementTask();
        this.plugin.getLogger().info("Playtime tracking started");
    }

    public void stopTracking() {
        if (this.incrementTask != null && !this.incrementTask.isCancelled()) {
            this.incrementTask.cancel();
            this.incrementTask = null;
        }
        if (this.saveTask != null && !this.saveTask.isCancelled()) {
            this.saveTask.cancel();
            this.saveTask = null;
        }
        this.plugin.getLogger().info("Playtime tracking stopped");
    }

    private void startIncrementTask() {
        int intervalSeconds = this.plugin.getConfigManager().getIncrementInterval();
        long intervalTicks = (long)intervalSeconds * 20L;
        this.incrementTask = new BukkitRunnable(){

            public void run() {
                PlaytimeTracker.this.incrementPlaytimeForOnlinePlayers();
            }
        }.runTaskTimer((Plugin)this.plugin, intervalTicks, intervalTicks);
        this.plugin.getLogger().info("Playtime increment task started (interval: " + intervalSeconds + " seconds)");
    }

    private void incrementPlaytimeForOnlinePlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            try {
                this.dataManager.addPlaytime(player.getUniqueId(), 1);
                if (!this.plugin.getConfigManager().shouldLogPlaytimeUpdates()) continue;
                int totalPlaytime = this.dataManager.getPlayerPlaytime(player.getUniqueId());
                this.plugin.getLogger().info("Updated playtime for " + player.getName() + ": " + totalPlaytime + " minutes");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to increment playtime for " + player.getName() + ": " + e.getMessage());
            }
        }
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Incremented playtime for " + Bukkit.getOnlinePlayers().size() + " players");
        }
    }

    public int getIncrementInterval() {
        return this.plugin.getConfigManager().getIncrementInterval();
    }

    public boolean isTracking() {
        return this.incrementTask != null && !this.incrementTask.isCancelled();
    }

    public String getTrackingStats() {
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        boolean tracking = this.isTracking();
        int interval = this.getIncrementInterval();
        return String.format("Tracking: %s, Online Players: %d, Interval: %d seconds", tracking ? "Active" : "Inactive", onlinePlayers, interval);
    }
}

