/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLServerDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ByteColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnType;", "", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "", "value", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Byte;", "valueToDB", "(Ljava/lang/Byte;)Ljava/lang/Object;", "exposed-core"})
public final class ByteColumnType
extends ColumnType<Byte> {
    public ByteColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().byteType();
    }

    @Override
    @NotNull
    public Byte valueFromDB(@NotNull Object value) {
        byte by;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Byte) {
            by = ((Number)value).byteValue();
        } else if (object instanceof Number) {
            by = ((Number)value).byteValue();
        } else if (object instanceof String) {
            by = Byte.parseByte((String)value);
        } else {
            throw new IllegalStateException(("Unexpected value of type Byte: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return by;
    }

    @Override
    @Nullable
    public Object valueToDB(@Nullable Byte value) {
        Object object;
        if (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect) {
            Byte by = value;
            object = by != null ? Short.valueOf(by.byteValue()) : null;
        } else {
            object = super.valueToDB(value);
        }
        return object;
    }
}

