/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.datetime;

import java.sql.Date;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IDateColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.datetime.LocalDateColumnTypeKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.RowApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Dialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Kt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.OracleDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLiteDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001c\u0010\u000f\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0019\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0006\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001c\u0010\u0019\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0014J\u001c\u0010\u001a\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0010J!\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006&"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/datetime/LocalDateColumnType;", "T", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/IDateColumnType;", "<init>", "()V", "value", "Lkotlinx/datetime/LocalDate;", "toLocalDate", "(Ljava/lang/Object;)Lkotlinx/datetime/LocalDate;", "fromLocalDate", "(Lkotlinx/datetime/LocalDate;)Ljava/lang/Object;", "", "sqlType", "()Ljava/lang/String;", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "", "localDateValueFromDB", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "", "epochMillis", "longToLocalDate", "(J)Lkotlinx/datetime/LocalDate;", "notNullValueToDB", "nonNullValueAsDefaultString", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;", "rs", "", "index", "readObject", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;I)Ljava/lang/Object;", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "exposed-core"})
public abstract class LocalDateColumnType<T>
extends ColumnType<T>
implements IDateColumnType {
    private final boolean hasTimePart;

    public LocalDateColumnType() {
        super(false, 1, null);
    }

    @NotNull
    public abstract LocalDate toLocalDate(T var1);

    public abstract T fromLocalDate(@NotNull LocalDate var1);

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        LocalDate localDate = this.toLocalDate(value);
        Instant instant = LocalDateColumnTypeKt.access$atStartOfDayIn(localDate, TimeZone.Companion.currentSystemDefault());
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? LocalDateColumnTypeKt.access$oracleDateLiteral(instant) : '\'' + LocalDateColumnTypeKt.access$formatDate(instant, TimeZone.Companion.currentSystemDefault()) + '\'';
    }

    private final LocalDate localDateValueFromDB(Object value) {
        Object object = value;
        return object instanceof LocalDate ? (LocalDate)value : (object instanceof Date ? this.longToLocalDate(((Date)value).getTime()) : (object instanceof Timestamp ? this.longToLocalDate(((Timestamp)value).getTime()) : (object instanceof Integer ? this.longToLocalDate(((Number)value).intValue()) : (object instanceof Long ? this.longToLocalDate(((Number)value).longValue()) : (object instanceof String ? LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)((CharSequence)value), null, (int)2, null) : LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)value.toString(), null, (int)2, null))))));
    }

    @Override
    @Nullable
    public T valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fromLocalDate(this.localDateValueFromDB(value));
    }

    private final LocalDate longToLocalDate(long epochMillis) {
        Instant instant = Instant.Companion.fromEpochMilliseconds(epochMillis);
        return TimeZoneKt.toLocalDateTime((Instant)instant, (TimeZone)TimeZone.Companion.currentSystemDefault()).getDate();
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        LocalDate localDate = this.toLocalDate(value);
        Instant instant = LocalDateColumnTypeKt.access$atStartOfDayIn(localDate, TimeZone.Companion.currentSystemDefault());
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? LocalDateColumnTypeKt.access$formatDate(instant, TimeZone.Companion.currentSystemDefault()) : new Date(instant.toEpochMilliseconds());
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect ? this.nonNullValueToString(value) + "::date" : super.nonNullValueAsDefaultString(value);
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        return dialect instanceof OracleDialect || H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle ? rs.getObject(index, Timestamp.class, (IColumnType)this) : super.readObject(rs, index);
    }
}

