/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.AbstractQuery;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Column;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Table;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Transaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.Statement;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.StatementType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0010\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r0\f0\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R!\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001e\u001a\u0004\b\t\u0010\u001f\u00a8\u0006 "}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/InsertSelectStatement;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/Statement;", "", "", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;", "columns", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/AbstractQuery;", "selectQuery", "", "isIgnore", "<init>", "(Ljava/util/List;Lorg/jetbrains/exposed/v1/core/AbstractQuery;Z)V", "", "Lkotlin/Pair;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/IColumnType;", "", "arguments", "()Ljava/lang/Iterable;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Transaction;", "transaction", "prepared", "", "prepareSQL", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Transaction;Z)Ljava/lang/String;", "Ljava/util/List;", "getColumns", "()Ljava/util/List;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/AbstractQuery;", "getSelectQuery", "()Lorg/jetbrains/exposed/v1/core/AbstractQuery;", "Z", "()Z", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nInsertSelectStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertSelectStatement.kt\norg/jetbrains/exposed/v1/core/statements/InsertSelectStatement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1669#2,8:35\n*S KotlinDebug\n*F\n+ 1 InsertSelectStatement.kt\norg/jetbrains/exposed/v1/core/statements/InsertSelectStatement\n*L\n24#1:35,8\n*E\n"})
public class InsertSelectStatement
extends Statement<Integer> {
    @NotNull
    private final List<Column<?>> columns;
    @NotNull
    private final AbstractQuery<?> selectQuery;
    private final boolean isIgnore;

    public InsertSelectStatement(@NotNull List<? extends Column<?>> columns, @NotNull AbstractQuery<?> selectQuery, boolean isIgnore) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(selectQuery, (String)"selectQuery");
        super(StatementType.INSERT, CollectionsKt.listOf((Object)((Column)CollectionsKt.first(columns)).getTable()));
        this.columns = columns;
        this.selectQuery = selectQuery;
        this.isIgnore = isIgnore;
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("Can't insert without provided columns".toString());
        }
        Iterable $this$distinctBy$iv = this.columns;
        boolean $i$f$distinctBy = false;
        HashSet<Table> set$iv = new HashSet<Table>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Column it = (Column)e$iv;
            boolean bl = false;
            Table key$iv = it.getTable();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List tables = list$iv;
        if (((Collection)tables).size() > 1) {
            throw new IllegalStateException(("Can't insert to different tables " + CollectionsKt.joinToString$default((Iterable)tables, null, null, null, (int)0, null, InsertSelectStatement::_init_$lambda$1, (int)31, null) + " from single select").toString());
        }
        if (this.columns.size() != this.selectQuery.getSet().getFields().size()) {
            throw new IllegalStateException("Columns count doesn't equal to query columns count".toString());
        }
    }

    public /* synthetic */ InsertSelectStatement(List list, AbstractQuery abstractQuery, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list, abstractQuery, bl);
    }

    @NotNull
    public final List<Column<?>> getColumns() {
        return this.columns;
    }

    @NotNull
    public final AbstractQuery<?> getSelectQuery() {
        return this.selectQuery;
    }

    public final boolean isIgnore() {
        return this.isIgnore;
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.selectQuery.arguments();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction, boolean prepared2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return transaction.getDb().getDialect().getFunctionProvider().insert(this.isIgnore, (Table)CollectionsKt.single(this.getTargets()), this.columns, this.selectQuery.prepareSQL(transaction, prepared2), transaction);
    }

    private static final CharSequence _init_$lambda$1(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

