/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.OracleDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ\u001a\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u0010*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R$\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/ExposedBlob;", "", "Ljava/io/InputStream;", "inputStream", "<init>", "(Ljava/io/InputStream;)V", "", "bytes", "([B)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "hexString", "()Ljava/lang/String;", "toHexString", "([B)Ljava/lang/String;", "value", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "getBytes", "()[B", "exposed-core"})
public final class ExposedBlob {
    @NotNull
    private InputStream inputStream;

    public ExposedBlob(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
    }

    public ExposedBlob(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this(new ByteArrayInputStream(bytes));
    }

    @NotNull
    public final InputStream getInputStream() {
        return this.inputStream;
    }

    @NotNull
    public final byte[] getBytes() {
        byte[] byArray;
        byte[] it = byArray = ByteStreamsKt.readBytes((InputStream)this.inputStream);
        boolean bl = false;
        if (this.inputStream.markSupported()) {
            try {
                this.inputStream.reset();
            }
            catch (IOException iOException) {
                if (DatabaseDialectKt.getCurrentDialectIfAvailable() instanceof OracleDialect) {
                    this.inputStream = new ByteArrayInputStream(it);
                }
            }
        } else {
            this.inputStream = new ByteArrayInputStream(it);
        }
        return byArray;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExposedBlob)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), ((ExposedBlob)other).getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    @NotNull
    public final String hexString() {
        return this.toHexString(this.getBytes());
    }

    private final String toHexString(byte[] $this$toHexString) {
        return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)"", null, null, (int)0, null, ExposedBlob::toHexString$lambda$1, (int)30, null);
    }

    private static final CharSequence toHexString$lambda$1(byte eachByte) {
        String string = "%02x";
        Object[] objectArray = new Object[]{eachByte};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

