/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExpressionKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IDateColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IExpressionAlias;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.JsonColumnMarker;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.LiteralOp;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.QueryBuilder;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SortOrder;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.exceptions.UnsupportedByDialectException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0006J\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0006J\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u000f\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\u0006J\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u0006J\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0006J\u000f\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0006J\u000f\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0006J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0006J\u001b\u0010\u0019\u001a\u00020\u00042\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ+\u0010!\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MysqlDataTypeProvider;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "<init>", "()V", "", "binaryType", "()Ljava/lang/String;", "dateTimeType", "timestampWithTimeZoneType", "ubyteType", "ushortType", "uintegerType", "uintegerAutoincType", "ulongType", "ulongAutoincType", "textType", "mediumTextType", "largeTextType", "value", "", "booleanFromStringToBoolean", "(Ljava/lang/String;)Z", "jsonBType", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "e", "processForDefaultValue", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/QueryBuilder;", "queryBuilder", "expression", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/SortOrder;", "sortOrder", "", "precessOrderByClause", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/QueryBuilder;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/SortOrder;)V", "hexString", "hexToDb", "(Ljava/lang/String;)Ljava/lang/String;", "Companion", "exposed-core"})
public class MysqlDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MysqlDataTypeProvider INSTANCE = new MysqlDataTypeProvider();

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    @NotNull
    public String dateTimeType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        return (mysqlDialect != null ? mysqlDialect.isFractionDateTimeSupported() : false) ? "DATETIME(6)" : "DATETIME";
    }

    @Override
    @NotNull
    public String timestampWithTimeZoneType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        if (!(mysqlDialect != null ? mysqlDialect.isTimeZoneOffsetSupported() : false)) {
            throw new UnsupportedByDialectException("This vendor does not support timestamp with time zone data type for this version", DatabaseDialectKt.getCurrentDialect());
        }
        return "TIMESTAMP(6)";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "TINYINT UNSIGNED";
    }

    @Override
    @NotNull
    public String ushortType() {
        return "SMALLINT UNSIGNED";
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "INT UNSIGNED";
    }

    @Override
    @NotNull
    public String uintegerAutoincType() {
        return "INT UNSIGNED AUTO_INCREMENT";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "BIGINT UNSIGNED";
    }

    @Override
    @NotNull
    public String ulongAutoincType() {
        return "BIGINT UNSIGNED AUTO_INCREMENT";
    }

    @Override
    @NotNull
    public String textType() {
        return "text";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return "MEDIUMTEXT";
    }

    @Override
    @NotNull
    public String largeTextType() {
        return "LONGTEXT";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value;
        return Intrinsics.areEqual((Object)string, (Object)"0") ? false : (Intrinsics.areEqual((Object)string, (Object)"1") ? true : Boolean.parseBoolean(value));
    }

    @Override
    @NotNull
    public String jsonBType() {
        return "JSON";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof JsonColumnMarker) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
            Object object = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
            if (object == null || (object = ((MysqlDialect)object).getFullVersion$exposed_core()) == null) {
                object = "0";
            }
            if (((String)object).compareTo("8.0.13") < 0) throw new UnsupportedByDialectException("MySQL versions prior to 8.0.13 do not accept default values on JSON columns", DatabaseDialectKt.getCurrentDialect());
            string = '(' + super.processForDefaultValue(e) + ')';
            return string;
        }
        if (e instanceof ExpressionWithColumnType && ((ExpressionWithColumnType)e).getColumnType() instanceof IDateColumnType && StringsKt.startsWith$default((String)((ExpressionWithColumnType)e).toString(), (String)"CURRENT_TIMESTAMP", (boolean)false, (int)2, null)) {
            string = super.processForDefaultValue(e);
            return string;
        }
        if (!(e instanceof LiteralOp)) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
            Object object = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
            if (object == null || (object = ((MysqlDialect)object).getFullVersion$exposed_core()) == null) {
                object = "0";
            }
            if (((String)object).compareTo("8.0.13") >= 0) {
                string = '(' + super.processForDefaultValue(e) + ')';
                return string;
            }
        }
        string = super.processForDefaultValue(e);
        return string;
    }

    @Override
    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause(queryBuilder, expression, sortOrder);
                break;
            }
            case 3: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.ASC);
                break;
            }
            case 4: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.DESC);
                break;
            }
            default: {
                Object object = expression instanceof IExpressionAlias ? (IExpressionAlias)((Object)expression) : null;
                if (object == null || (object = object.getAlias()) == null) {
                    object = expression;
                }
                Expression<?> exp = object;
                String nullExp = sortOrder == SortOrder.ASC_NULLS_LAST ? " IS NULL" : " IS NOT NULL";
                SortOrder order = sortOrder == SortOrder.ASC_NULLS_LAST ? SortOrder.ASC : SortOrder.DESC;
                Object[] objectArray = new Object[]{exp, nullExp, ", ", exp, " ", order.getCode()};
                ExpressionKt.append(queryBuilder, objectArray);
            }
        }
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        return "0x" + hexString;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MysqlDataTypeProvider$Companion;", "", "<init>", "()V", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MysqlDataTypeProvider;", "INSTANCE", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MysqlDataTypeProvider;", "getINSTANCE$exposed_core", "()Lorg/jetbrains/exposed/v1/core/vendors/MysqlDataTypeProvider;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MysqlDataTypeProvider getINSTANCE$exposed_core() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

