/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Column;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Index;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLiteDataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLiteFunctionProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.VendorDialect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001a\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001b\u001a\u0004\b\u001f\u0010\u001dR\u001a\u0010 \u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b!\u0010\u001dR\u001a\u0010\"\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\"\u0010\u001b\u001a\u0004\b#\u0010\u001d\u00a8\u0006%"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/SQLiteDialect;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect;", "<init>", "()V", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;)Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;", "index", "", "createIndex", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;)Ljava/lang/String;", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "listDatabases", "()Ljava/lang/String;", "dropDatabase", "supportsCreateSequence", "Z", "getSupportsCreateSequence", "()Z", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsCreateSchema", "getSupportsCreateSchema", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "Companion", "exposed-core"})
public class SQLiteDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsCreateSequence;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsCreateSchema;
    private final boolean supportsWindowFrameGroupsMode;

    public SQLiteDialect() {
        super(Companion.getDialectName(), SQLiteDataTypeProvider.INSTANCE, SQLiteFunctionProvider.INSTANCE);
        this.supportsWindowFrameGroupsMode = true;
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return this.supportsCreateSchema;
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return this.supportsWindowFrameGroupsMode;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, SQLiteDialect::createIndex$lambda$0, (int)31, null) + " can't be created in SQLite");
            return "";
        }
        String originalCreateIndex = super.createIndex(Index.copy$default(index, null, false, null, null, null, null, null, 125, null));
        return index.getUnique() ? StringsKt.replace$default((String)originalCreateIndex, (String)"CREATE INDEX", (String)"CREATE UNIQUE INDEX", (boolean)false, (int)4, null) : originalCreateIndex;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "DROP INDEX IF EXISTS " + this.getIdentifierManager().cutIfNecessaryAndQuote(indexName);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StringBuilder stringBuilder = new StringBuilder().append("ATTACH DATABASE '");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return stringBuilder.append(string).append(".db' AS ").append(DatabaseDialectKt.inProperCase(name)).toString();
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SELECT name FROM pragma_database_list";
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DETACH DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    private static final CharSequence createIndex$lambda$0(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/SQLiteDialect$Companion;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("SQLite");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

