/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.common.commands;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.coordshud.api.ITextSerializer;
import me.jfenn.coordshud.api.commands.CommandArgument;
import me.jfenn.coordshud.api.commands.CommandBuilder;
import me.jfenn.coordshud.api.commands.ICommandManager;
import me.jfenn.coordshud.api.commands.IExecutionContext;
import me.jfenn.coordshud.common.config.CoordsHudConfig;
import me.jfenn.coordshud.common.db.PlayerDao;
import me.jfenn.coordshud.common.db.PlayerRecord;
import me.jfenn.coordshud.common.hud.HudState;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lme/jfenn/coordshud/common/commands/CoordsHudCommand;", "", "Lme/jfenn/coordshud/common/db/PlayerDao;", "playerDao", "Lme/jfenn/coordshud/api/ITextSerializer;", "textSerializer", "Lme/jfenn/coordshud/common/config/CoordsHudConfig;", "config", "Lme/jfenn/coordshud/common/hud/HudState;", "state", "Lme/jfenn/coordshud/api/commands/ICommandManager;", "commandManager", "<init>", "(Lme/jfenn/coordshud/common/db/PlayerDao;Lme/jfenn/coordshud/api/ITextSerializer;Lme/jfenn/coordshud/common/config/CoordsHudConfig;Lme/jfenn/coordshud/common/hud/HudState;Lme/jfenn/coordshud/api/commands/ICommandManager;)V", "Lnet/minecraft/class_3222;", "player", "", "toggleEnabled", "(Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_2561;", "text", "setPlayerFormat", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2561;)V", "Lme/jfenn/coordshud/common/db/PlayerDao;", "Lme/jfenn/coordshud/api/ITextSerializer;", "Lme/jfenn/coordshud/common/config/CoordsHudConfig;", "Lme/jfenn/coordshud/common/hud/HudState;", "coordshud-common"})
@SourceDebugExtension(value={"SMAP\nCoordsHudCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordsHudCommand.kt\nme/jfenn/coordshud/common/commands/CoordsHudCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class CoordsHudCommand {
    @NotNull
    private final PlayerDao playerDao;
    @NotNull
    private final ITextSerializer textSerializer;
    @NotNull
    private final CoordsHudConfig config;
    @NotNull
    private final HudState state;

    public CoordsHudCommand(@NotNull PlayerDao playerDao, @NotNull ITextSerializer textSerializer, @NotNull CoordsHudConfig config, @NotNull HudState state, @NotNull ICommandManager commandManager) {
        Intrinsics.checkNotNullParameter((Object)playerDao, (String)"playerDao");
        Intrinsics.checkNotNullParameter((Object)textSerializer, (String)"textSerializer");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        this.playerDao = playerDao;
        this.textSerializer = textSerializer;
        this.config = config;
        this.state = state;
        commandManager.register("coordshud", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> CoordsHudCommand._init_$lambda$8(this, arg_0)));
    }

    private final void toggleEnabled(class_3222 player) {
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        PlayerRecord it = this.playerDao.getPlayer(uUID);
        boolean bl = false;
        boolean isEnabled = !it.isEnabled(this.config);
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUuid(...)");
        this.playerDao.setEnabled(uUID2, isEnabled);
        if (!isEnabled) {
            player.method_7353((class_2561)class_2561.method_43473(), true);
        } else {
            this.state.getTitleTracker().remove(player);
        }
    }

    private final void setPlayerFormat(class_3222 player, class_2561 text) {
        String string;
        class_2561 class_25612 = text;
        if (class_25612 != null) {
            class_2561 it = class_25612;
            boolean bl = false;
            string = this.textSerializer.toJson(it);
        } else {
            string = null;
        }
        String json = string;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        this.playerDao.setFormat(uUID, json);
    }

    private static final Unit lambda$8$lambda$2(CoordsHudCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        class_3222 class_32222 = $this$executes.getPlayer();
        if (class_32222 == null) {
            throw new IllegalArgumentException();
        }
        this$0.toggleEnabled(class_32222);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$7$lambda$4$lambda$3(CommandArgument $textArg, CoordsHudCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        class_3222 class_32222 = $this$executes.getPlayer();
        if (class_32222 == null) {
            throw new IllegalArgumentException();
        }
        class_3222 player = class_32222;
        class_2561 text = (class_2561)$this$executes.getArgument($textArg);
        this$0.setPlayerFormat(player, text);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$7$lambda$4(CoordsHudCommand this$0, CommandBuilder $this$text, CommandArgument textArg) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        Intrinsics.checkNotNullParameter((Object)textArg, (String)"textArg");
        $this$text.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> CoordsHudCommand.lambda$8$lambda$7$lambda$4$lambda$3(textArg, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$7$lambda$6$lambda$5(CoordsHudCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        class_3222 class_32222 = $this$executes.getPlayer();
        if (class_32222 == null) {
            throw new IllegalArgumentException();
        }
        class_3222 player = class_32222;
        this$0.setPlayerFormat(player, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$7$lambda$6(CoordsHudCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> CoordsHudCommand.lambda$8$lambda$7$lambda$6$lambda$5(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$7(CoordsHudCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.text("text", (Function2<? super CommandBuilder, ? super CommandArgument<class_2561>, Unit>)((Function2)(arg_0, arg_1) -> CoordsHudCommand.lambda$8$lambda$7$lambda$4(this$0, arg_0, arg_1)));
        $this$literal.literal("default", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> CoordsHudCommand.lambda$8$lambda$7$lambda$6(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(CoordsHudCommand this$0, CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> CoordsHudCommand.lambda$8$lambda$2(this$0, arg_0)));
        $this$register.literal("format", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> CoordsHudCommand.lambda$8$lambda$7(this$0, arg_0)));
        return Unit.INSTANCE;
    }
}

