/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u0000*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR?\u0010!\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00018\u00008\u0000 \u001c*\u0012\u0012\u000e\b\u0001\u0012\n \u001c*\u0004\u0018\u00018\u00008\u00000\u001b0\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/EnumerationColumnType;", "", "T", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnType;", "Lkotlin/reflect/KClass;", "klass", "<init>", "(Lkotlin/reflect/KClass;)V", "", "sqlType", "()Ljava/lang/String;", "", "value", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Enum;", "", "notNullValueToDB", "(Ljava/lang/Enum;)Ljava/lang/Integer;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Lkotlin/reflect/KClass;", "getKlass", "()Lkotlin/reflect/KClass;", "", "kotlin.jvm.PlatformType", "enumConstants$delegate", "Lkotlin/Lazy;", "getEnumConstants", "()[Ljava/lang/Enum;", "enumConstants", "exposed-core"})
public final class EnumerationColumnType<T extends Enum<T>>
extends ColumnType<T> {
    @NotNull
    private final KClass<T> klass;
    @NotNull
    private final Lazy enumConstants$delegate;

    public EnumerationColumnType(@NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        super(false, 1, null);
        this.klass = klass;
        this.enumConstants$delegate = LazyKt.lazy(() -> EnumerationColumnType.enumConstants_delegate$lambda$0(this));
    }

    @NotNull
    public final KClass<T> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().integerType();
    }

    private final T[] getEnumConstants() {
        Lazy lazy = this.enumConstants$delegate;
        return (Enum[])lazy.getValue();
    }

    @Override
    @NotNull
    public T valueFromDB(@NotNull Object value) {
        Enum enum_;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Number) {
            Enum enum_2 = this.getEnumConstants()[((Number)value).intValue()];
            enum_ = enum_2;
            Intrinsics.checkNotNullExpressionValue((Object)enum_2, (String)"get(...)");
        } else if (object instanceof Enum) {
            enum_ = (Enum)value;
        } else {
            throw new IllegalStateException((value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getSimpleName()).toString());
        }
        return (T)enum_;
    }

    @Override
    @NotNull
    public Integer notNullValueToDB(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return ((Enum)value).ordinal();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.EnumerationColumnType<*>");
        EnumerationColumnType cfr_ignored_0 = (EnumerationColumnType)other;
        return Intrinsics.areEqual(this.klass, ((EnumerationColumnType)other).klass);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.klass.hashCode();
        return result;
    }

    private static final Enum[] enumConstants_delegate$lambda$0(EnumerationColumnType this$0) {
        T[] TArray = JvmClassMappingKt.getJavaClass(this$0.klass).getEnumConstants();
        Intrinsics.checkNotNull(TArray);
        return (Enum[])TArray;
    }
}

