/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Column;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.DdlAware;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ReferenceOption;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Table;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Transaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.IdentifierManagerApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u001a\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bB?\b\u0016\u0012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u001f\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ$\u0010\u001b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u0012\u0010 \u001a\u0004\u0018\u00010\bH\u00c2\u0003\u00a2\u0006\u0004\b \u0010\u001aJR\u0010!\u001a\u00020\u00002\u001c\b\u0002\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u001a\u0010%\u001a\u00020$2\b\u0010\u0016\u001a\u0004\u0018\u00010#H\u00d6\u0003\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010(\u001a\u00020'H\u00d6\u0001\u00a2\u0006\u0004\b(\u0010)R+\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010*\u001a\u0004\b+\u0010\u001cR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010,R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010,R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010-R\u001a\u00103\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b1\u00102\u001a\u0004\b/\u00100R/\u0010\f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000304j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`58\u0006\u00a2\u0006\f\n\u0004\b\f\u00106\u001a\u0004\b7\u00108R\u0017\u0010:\u001a\u0002098\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\u0011\u0010?\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001aR\u0014\u0010A\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001aR/\u0010\r\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000304j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`58\u0006\u00a2\u0006\f\n\u0004\b\r\u00106\u001a\u0004\bB\u00108R\u0017\u0010C\u001a\u0002098\u0006\u00a2\u0006\f\n\u0004\bC\u0010;\u001a\u0004\bD\u0010=R\u0011\u0010F\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u001aR\u0014\u0010H\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u001aR\u0013\u0010K\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0013\u0010M\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\bL\u0010JR\u0013\u0010O\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u001aR\u0011\u0010Q\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u001aR\u0014\u0010S\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u001a\u00a8\u0006T"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ForeignKeyConstraint;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DdlAware;", "", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;", "references", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ReferenceOption;", "onUpdate", "onDelete", "", "name", "<init>", "(Ljava/util/Map;Lorg/jetbrains/exposed/v1/core/ReferenceOption;Lorg/jetbrains/exposed/v1/core/ReferenceOption;Ljava/lang/String;)V", "target", "from", "(Lorg/jetbrains/exposed/v1/core/Column;Lorg/jetbrains/exposed/v1/core/Column;Lorg/jetbrains/exposed/v1/core/ReferenceOption;Lorg/jetbrains/exposed/v1/core/ReferenceOption;Ljava/lang/String;)V", "", "createStatement", "()Ljava/util/List;", "modifyStatement", "dropStatement", "targetOf", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;)Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;", "other", "plus", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ForeignKeyConstraint;)Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ForeignKeyConstraint;", "toString", "()Ljava/lang/String;", "component1", "()Ljava/util/Map;", "component2", "()Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ReferenceOption;", "component3", "component4", "copy", "(Ljava/util/Map;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ReferenceOption;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ReferenceOption;Ljava/lang/String;)Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ForeignKeyConstraint;", "", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/util/Map;", "getReferences", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ReferenceOption;", "Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Transaction;", "getTx", "()Lorg/jetbrains/exposed/v1/core/Transaction;", "getTx$annotations", "()V", "tx", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "Ljava/util/LinkedHashSet;", "getTarget", "()Ljava/util/LinkedHashSet;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;", "targetTable", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;", "getTargetTable", "()Lorg/jetbrains/exposed/v1/core/Table;", "getTargetTableName", "targetTableName", "getTargetColumns", "targetColumns", "getFrom", "fromTable", "getFromTable", "getFromTableName", "fromTableName", "getFromColumns", "fromColumns", "getUpdateRule", "()Lorg/jetbrains/exposed/v1/core/ReferenceOption;", "updateRule", "getDeleteRule", "deleteRule", "getCustomFkName", "customFkName", "getFkName", "fkName", "getForeignKeyPart$exposed_core", "foreignKeyPart", "exposed-core"})
public final class ForeignKeyConstraint
implements DdlAware {
    @NotNull
    private final Map<Column<?>, Column<?>> references;
    @Nullable
    private final ReferenceOption onUpdate;
    @Nullable
    private final ReferenceOption onDelete;
    @Nullable
    private final String name;
    @NotNull
    private final LinkedHashSet<Column<?>> target;
    @NotNull
    private final Table targetTable;
    @NotNull
    private final LinkedHashSet<Column<?>> from;
    @NotNull
    private final Table fromTable;

    public ForeignKeyConstraint(@NotNull Map<Column<?>, ? extends Column<?>> references, @Nullable ReferenceOption onUpdate, @Nullable ReferenceOption onDelete, @Nullable String name) {
        Intrinsics.checkNotNullParameter(references, (String)"references");
        this.references = references;
        this.onUpdate = onUpdate;
        this.onDelete = onDelete;
        this.name = name;
        this.target = new LinkedHashSet(this.references.values());
        this.targetTable = ((Column)CollectionsKt.first((Iterable)this.target)).getTable();
        this.from = new LinkedHashSet(this.references.keySet());
        this.fromTable = ((Column)CollectionsKt.first((Iterable)this.from)).getTable();
    }

    @NotNull
    public final Map<Column<?>, Column<?>> getReferences() {
        return this.references;
    }

    public ForeignKeyConstraint(@NotNull Column<?> target, @NotNull Column<?> from, @Nullable ReferenceOption onUpdate, @Nullable ReferenceOption onDelete, @Nullable String name) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this(MapsKt.mapOf((Pair)TuplesKt.to(from, target)), onUpdate, onDelete, name);
    }

    private final Transaction getTx() {
        return CoreTransactionManager.INSTANCE.currentTransaction();
    }

    private static /* synthetic */ void getTx$annotations() {
    }

    @NotNull
    public final LinkedHashSet<Column<?>> getTarget() {
        return this.target;
    }

    @NotNull
    public final Table getTargetTable() {
        return this.targetTable;
    }

    @NotNull
    public final String getTargetTableName() {
        return this.getTx().identity(this.targetTable);
    }

    private final String getTargetColumns() {
        return CollectionsKt.joinToString$default((Iterable)this.target, null, null, null, (int)0, null, arg_0 -> ForeignKeyConstraint._get_targetColumns_$lambda$0(this, arg_0), (int)31, null);
    }

    @NotNull
    public final LinkedHashSet<Column<?>> getFrom() {
        return this.from;
    }

    @NotNull
    public final Table getFromTable() {
        return this.fromTable;
    }

    @NotNull
    public final String getFromTableName() {
        return this.getTx().identity(this.fromTable);
    }

    private final String getFromColumns() {
        return CollectionsKt.joinToString$default((Iterable)this.from, null, null, null, (int)0, null, arg_0 -> ForeignKeyConstraint._get_fromColumns_$lambda$1(this, arg_0), (int)31, null);
    }

    @Nullable
    public final ReferenceOption getUpdateRule() {
        ReferenceOption referenceOption = this.onUpdate;
        if (referenceOption == null) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialectIfAvailable();
            referenceOption = databaseDialect != null ? databaseDialect.getDefaultReferenceOption() : null;
        }
        return referenceOption;
    }

    @Nullable
    public final ReferenceOption getDeleteRule() {
        ReferenceOption referenceOption = this.onDelete;
        if (referenceOption == null) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialectIfAvailable();
            referenceOption = databaseDialect != null ? databaseDialect.getDefaultReferenceOption() : null;
        }
        return referenceOption;
    }

    @Nullable
    public final String getCustomFkName() {
        return this.name;
    }

    @NotNull
    public final String getFkName() {
        IdentifierManagerApi identifierManagerApi = this.getTx().getDb().getIdentifierManager();
        String string = this.name;
        if (string == null) {
            string = "fk_" + StringsKt.replace$default((String)this.fromTable.getTableNameWithoutSchemeSanitized(), (char)'.', (char)'_', (boolean)false, (int)4, null) + '_' + CollectionsKt.joinToString$default((Iterable)this.from, (CharSequence)"_", null, null, (int)0, null, ForeignKeyConstraint::_get_fkName_$lambda$2, (int)30, null) + "__" + CollectionsKt.joinToString$default((Iterable)this.target, (CharSequence)"_", null, null, (int)0, null, ForeignKeyConstraint::_get_fkName_$lambda$3, (int)30, null);
        }
        return DatabaseDialectKt.inProperCase(identifierManagerApi.cutIfNecessaryAndQuote(string));
    }

    @NotNull
    public final String getForeignKeyPart$exposed_core() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_foreignKeyPart__u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)this.getFkName())) {
            $this$_get_foreignKeyPart__u24lambda_u244.append("CONSTRAINT " + this.getFkName() + ' ');
        }
        $this$_get_foreignKeyPart__u24lambda_u244.append("FOREIGN KEY (" + this.getFromColumns() + ") REFERENCES " + this.getTargetTableName() + '(' + this.getTargetColumns() + ')');
        if (this.getDeleteRule() != ReferenceOption.NO_ACTION) {
            if (this.getDeleteRule() == ReferenceOption.RESTRICT && !DatabaseDialectKt.getCurrentDialect().getSupportsRestrictReferenceOption()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with RESTRICT reference option with ON DELETE clause. Please check your " + this.getFromTableName() + " table.");
            } else if (this.getDeleteRule() == ReferenceOption.SET_DEFAULT && !DatabaseDialectKt.getCurrentDialect().getSupportsSetDefaultReferenceOption()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with SET DEFAULT reference option with ON DELETE clause. Please check your " + this.getFromTableName() + " table.");
            } else {
                $this$_get_foreignKeyPart__u24lambda_u244.append(" ON DELETE " + (Object)((Object)this.getDeleteRule()));
            }
        }
        if (this.getUpdateRule() != ReferenceOption.NO_ACTION) {
            if (!DatabaseDialectKt.getCurrentDialect().getSupportsOnUpdate()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with ON UPDATE clause. Please check your " + this.getFromTableName() + " table.");
            } else if (this.getUpdateRule() == ReferenceOption.RESTRICT && !DatabaseDialectKt.getCurrentDialect().getSupportsRestrictReferenceOption()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with RESTRICT reference option with ON UPDATE clause. Please check your " + this.getFromTableName() + " table.");
            } else if (this.getUpdateRule() == ReferenceOption.SET_DEFAULT && !DatabaseDialectKt.getCurrentDialect().getSupportsSetDefaultReferenceOption()) {
                SQLLogKt.getExposedLogger().warn(DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support FOREIGN KEY with SET DEFAULT reference option with ON UPDATE clause. Please check your " + this.getFromTableName() + " table.");
            } else {
                $this$_get_foreignKeyPart__u24lambda_u244.append(" ON UPDATE " + (Object)((Object)this.getUpdateRule()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.getFromTableName() + " ADD " + this.getForeignKeyPart$exposed_core()));
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        String constraintType = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect ? "FOREIGN KEY" : "CONSTRAINT";
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.getFromTableName() + " DROP " + constraintType + ' ' + this.getFkName()));
    }

    @Nullable
    public final Column<?> targetOf(@NotNull Column<?> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        return this.references.get(from);
    }

    @NotNull
    public final ForeignKeyConstraint plus(@NotNull ForeignKeyConstraint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ForeignKeyConstraint.copy$default(this, MapsKt.plus(this.references, other.references), null, null, null, 14, null);
    }

    @NotNull
    public String toString() {
        return "ForeignKeyConstraint(fkName='" + this.getFkName() + "')";
    }

    @NotNull
    public final Map<Column<?>, Column<?>> component1() {
        return this.references;
    }

    private final ReferenceOption component2() {
        return this.onUpdate;
    }

    private final ReferenceOption component3() {
        return this.onDelete;
    }

    private final String component4() {
        return this.name;
    }

    @NotNull
    public final ForeignKeyConstraint copy(@NotNull Map<Column<?>, ? extends Column<?>> references, @Nullable ReferenceOption onUpdate, @Nullable ReferenceOption onDelete, @Nullable String name) {
        Intrinsics.checkNotNullParameter(references, (String)"references");
        return new ForeignKeyConstraint(references, onUpdate, onDelete, name);
    }

    public static /* synthetic */ ForeignKeyConstraint copy$default(ForeignKeyConstraint foreignKeyConstraint, Map map, ReferenceOption referenceOption, ReferenceOption referenceOption2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = foreignKeyConstraint.references;
        }
        if ((n & 2) != 0) {
            referenceOption = foreignKeyConstraint.onUpdate;
        }
        if ((n & 4) != 0) {
            referenceOption2 = foreignKeyConstraint.onDelete;
        }
        if ((n & 8) != 0) {
            string = foreignKeyConstraint.name;
        }
        return foreignKeyConstraint.copy(map, referenceOption, referenceOption2, string);
    }

    public int hashCode() {
        int result = ((Object)this.references).hashCode();
        result = result * 31 + (this.onUpdate == null ? 0 : this.onUpdate.hashCode());
        result = result * 31 + (this.onDelete == null ? 0 : this.onDelete.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForeignKeyConstraint)) {
            return false;
        }
        ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)other;
        if (!Intrinsics.areEqual(this.references, foreignKeyConstraint.references)) {
            return false;
        }
        if (this.onUpdate != foreignKeyConstraint.onUpdate) {
            return false;
        }
        if (this.onDelete != foreignKeyConstraint.onDelete) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)foreignKeyConstraint.name);
    }

    @Override
    @NotNull
    public List<String> getDdl() {
        return DdlAware.DefaultImpls.getDdl(this);
    }

    private static final CharSequence _get_targetColumns_$lambda$0(ForeignKeyConstraint this$0, Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getTx().identity(it);
    }

    private static final CharSequence _get_fromColumns_$lambda$1(ForeignKeyConstraint this$0, Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getTx().identity(it);
    }

    private static final CharSequence _get_fkName_$lambda$2(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence _get_fkName_$lambda$3(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

