/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Index;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Schema;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Version;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlFunctionProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.VendorDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.exceptions.UnsupportedByDialectException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010!\n\u0002\b\u0006\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u001b\u0010\n\u001a\u00020\u00042\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR!\u0010#\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u0012\u0004\b\"\u0010\u0003\u001a\u0004\b!\u0010\u0006R!\u0010(\u001a\u00020\u000e8@X\u0080\u0084\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010 \u0012\u0004\b'\u0010\u0003\u001a\u0004\b%\u0010&R\u001a\u0010)\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010\u0006R\u001a\u0010,\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b,\u0010*\u001a\u0004\b-\u0010\u0006R\u001a\u0010.\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b.\u0010*\u001a\u0004\b/\u0010\u0006R\u001a\u00100\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b0\u0010*\u001a\u0004\b1\u0010\u0006R\u001a\u00102\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b2\u0010*\u001a\u0004\b3\u0010\u0006R \u00104\u001a\u00020\u00048\u0016X\u0097D\u00a2\u0006\u0012\n\u0004\b4\u0010*\u0012\u0004\b6\u0010\u0003\u001a\u0004\b5\u0010\u0006R \u00108\u001a\b\u0012\u0004\u0012\u00020\u000e078\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\u00a8\u0006="}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MysqlDialect;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect;", "<init>", "()V", "", "isFractionDateTimeSupported", "()Z", "isTimeZoneOffsetSupported", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "e", "isAllowedAsColumnDefault", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;)Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;", "index", "", "createIndex", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;)Ljava/lang/String;", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Schema;", "schema", "setSchema", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Schema;)Ljava/lang/String;", "createSchema", "cascade", "dropSchema", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Schema;Z)Ljava/lang/String;", "isMysql8$delegate", "Lkotlin/Lazy;", "isMysql8$exposed_core", "isMysql8$exposed_core$annotations", "isMysql8", "fullVersion$delegate", "getFullVersion$exposed_core", "()Ljava/lang/String;", "getFullVersion$exposed_core$annotations", "fullVersion", "supportsCreateSequence", "Z", "getSupportsCreateSequence", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsSelectForUpdate", "getSupportsSelectForUpdate", "getSupportsSelectForUpdate$annotations", "", "notAcceptableDefaults", "Ljava/util/List;", "getNotAcceptableDefaults", "()Ljava/util/List;", "Companion", "exposed-core"})
public class MysqlDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isMysql8$delegate = LazyKt.lazy(MysqlDialect::isMysql8_delegate$lambda$0);
    @NotNull
    private final Lazy fullVersion$delegate = LazyKt.lazy(MysqlDialect::fullVersion_delegate$lambda$1);
    private final boolean supportsCreateSequence;
    private final boolean supportsTernaryAffectedRowValues;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsSetDefaultReferenceOption;
    private final boolean supportsSelectForUpdate;
    @NotNull
    private final List<String> notAcceptableDefaults;

    public MysqlDialect() {
        super(Companion.getDialectName(), MysqlDataTypeProvider.Companion.getINSTANCE$exposed_core(), MysqlFunctionProvider.Companion.getINSTANCE$exposed_core());
        this.supportsTernaryAffectedRowValues = true;
        this.supportsSubqueryUnions = true;
        this.supportsSelectForUpdate = true;
        Object[] objectArray = new String[]{"CURRENT_DATE()", "CURRENT_DATE"};
        this.notAcceptableDefaults = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy = this.isMysql8$delegate;
        return (Boolean)lazy.getValue();
    }

    public static /* synthetic */ void isMysql8$exposed_core$annotations() {
    }

    @NotNull
    public final String getFullVersion$exposed_core() {
        Lazy lazy = this.fullVersion$delegate;
        return (String)lazy.getValue();
    }

    public static /* synthetic */ void getFullVersion$exposed_core$annotations() {
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return this.supportsTernaryAffectedRowValues;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    @Override
    public boolean getSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    @Deprecated(message="The parameter was moved to JdbcExposedDatabaseMetadata/R2dbcExposedDatabaseMetadata classes", replaceWith=@ReplaceWith(expression="TransactionManager.current().db.supportsSelectForUpdate", imports={}))
    public static /* synthetic */ void getSupportsSelectForUpdate$annotations() {
    }

    public boolean isFractionDateTimeSupported() {
        return Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 5, 6, 0, 4, null);
    }

    public boolean isTimeZoneOffsetSupported() {
        return this.isMysql8$exposed_core();
    }

    @NotNull
    protected final List<String> getNotAcceptableDefaults() {
        return this.notAcceptableDefaults;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (super.isAllowedAsColumnDefault(e)) {
            return true;
        }
        if (this.getFullVersion$exposed_core().compareTo("8.0.13") >= 0) {
            return true;
        }
        return !this.notAcceptableDefaults.contains(((Object)StringsKt.trim((CharSequence)e.toString())).toString());
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getFunctions() != null && !this.isMysql8$exposed_core()) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, MysqlDialect::createIndex$lambda$2, (int)31, null) + " can't be created in MySQL prior to 8.0");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP INDEX " + this.getIdentifierManager().cutIfNecessaryAndQuote(indexName);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "USE " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u243, (String[])stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(DatabaseDialectKt.getCurrentDialect().getName() + " do not have database owners. You can use GRANT to allow or deny rights on database.", DatabaseDialectKt.getCurrentDialect());
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "DROP SCHEMA IF EXISTS " + schema.getIdentifier();
    }

    private static final boolean isMysql8_delegate$lambda$0() {
        return CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion().covers("8.0");
    }

    private static final String fullVersion_delegate$lambda$1() {
        return CoreTransactionManager.INSTANCE.currentTransaction().getDb().getFullVersion();
    }

    private static final CharSequence createIndex$lambda$2(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MysqlDialect$Companion;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MySQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

