/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.migration.jdbc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.CheckConstraint;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Column;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExperimentalDatabaseMigrationApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ForeignKeyConstraint;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Index;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SchemaUtilityApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Sequence;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Table;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.ColumnMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PrimaryKeyMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.MetadataQueriesKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.SchemaUtils;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.transactions.TransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.DatabaseDialectMetadataKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.migration.core.MigrationUtilityApi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\r\u001a\u00020\f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ1\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J3\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J1\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0011J1\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0011J1\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0011J3\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0011J1\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0011J1\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0011J1\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0011J1\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/migration/jdbc/MigrationUtils;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/migration/core/MigrationUtilityApi;", "<init>", "()V", "", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;", "tables", "", "scriptDirectory", "scriptName", "", "withLogs", "Ljava/io/File;", "generateMigrationScript", "([Lorg/jetbrains/exposed/v1/core/Table;Ljava/lang/String;Ljava/lang/String;Z)Ljava/io/File;", "", "statementsRequiredForDatabaseMigration", "([Lorg/jetbrains/exposed/v1/core/Table;Z)Ljava/util/List;", "addMissingAndDropUnmappedColumns", "dropUnmappedColumnsStatements", "dropUnmappedIndices", "dropUnmappedSequences", "mappingConsistenceRequiredStatements", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Sequence;", "checkMissingSequences", "checkUnmappedSequences", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/CheckConstraint;", "checkMissingCheckConstraints", "checkUnmappedCheckConstraints", "exposed-migration-jdbc"})
@SourceDebugExtension(value={"SMAP\nMigrationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationUtils.kt\norg/jetbrains/exposed/v1/migration/jdbc/MigrationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 SchemaUtilityApi.kt\norg/jetbrains/exposed/v1/core/SchemaUtilityApi\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,351:1\n1#2:352\n23663#3,10:353\n13472#3,2:443\n13472#3:509\n13473#3:517\n13472#3:518\n13473#3:526\n536#4,3:363\n539#4,4:370\n536#4,3:374\n539#4,4:383\n536#4,3:387\n539#4,4:394\n536#4,3:398\n539#4,4:408\n536#4,7:415\n536#4,7:422\n536#4,7:429\n536#4,7:436\n37#5:366\n36#5,3:367\n37#5:390\n36#5,3:391\n37#5:401\n36#5,3:402\n1374#6:377\n1460#6,5:378\n774#6:405\n865#6,2:406\n774#6:412\n865#6,2:413\n1374#6:445\n1460#6,5:446\n1374#6:451\n1460#6,5:452\n1374#6:457\n1460#6,5:458\n1374#6:463\n1460#6,5:464\n1374#6:469\n1460#6,5:470\n1374#6:475\n1460#6,5:476\n1374#6:481\n1460#6,5:482\n1374#6:487\n1460#6,5:488\n1374#6:493\n1460#6,5:494\n1374#6:499\n1460#6,2:500\n1563#6:502\n1634#6,3:503\n1462#6,3:506\n1563#6:510\n1634#6,3:511\n827#6:514\n855#6,2:515\n1563#6:519\n1634#6,3:520\n827#6:523\n855#6,2:524\n*S KotlinDebug\n*F\n+ 1 MigrationUtils.kt\norg/jetbrains/exposed/v1/migration/jdbc/MigrationUtils\n*L\n70#1:353,10\n174#1:443,2\n317#1:509\n317#1:517\n340#1:518\n340#1:526\n73#1:363,3\n73#1:370,4\n78#1:374,3\n78#1:383,4\n83#1:387,3\n83#1:394,4\n88#1:398,3\n88#1:408,4\n105#1:415,7\n109#1:422,7\n135#1:429,7\n170#1:436,7\n74#1:366\n74#1:367,3\n84#1:390\n84#1:391,3\n90#1:401\n90#1:402,3\n79#1:377\n79#1:378,5\n92#1:405\n92#1:406,2\n92#1:412\n92#1:413,2\n206#1:445\n206#1:446,5\n226#1:451\n226#1:452,5\n249#1:457\n249#1:458,5\n250#1:463\n250#1:464,5\n251#1:469\n251#1:470,5\n252#1:475\n252#1:476,5\n253#1:481\n253#1:482,5\n254#1:487\n254#1:488,5\n255#1:493\n255#1:494,5\n293#1:499\n293#1:500,2\n293#1:502\n293#1:503,3\n293#1:506,3\n320#1:510\n320#1:511,3\n321#1:514\n321#1:515,2\n343#1:519\n343#1:520,3\n345#1:523\n345#1:524,2\n*E\n"})
public final class MigrationUtils
extends MigrationUtilityApi {
    @NotNull
    public static final MigrationUtils INSTANCE = new MigrationUtils();

    private MigrationUtils() {
    }

    @ExperimentalDatabaseMigrationApi
    @NotNull
    public final File generateMigrationScript(@NotNull Table[] tables, @NotNull String scriptDirectory, @NotNull String scriptName, boolean withLogs) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Intrinsics.checkNotNullParameter((Object)scriptDirectory, (String)"scriptDirectory");
        Intrinsics.checkNotNullParameter((Object)scriptName, (String)"scriptName");
        if (!(!(tables.length == 0))) {
            boolean bl = false;
            String string = "Tables argument must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        List<String> allStatements = this.statementsRequiredForDatabaseMigration(Arrays.copyOf(tables, tables.length), withLogs);
        return this.writeMigrationScriptTo(allStatements, scriptDirectory + '/' + scriptName + ".sql");
    }

    public static /* synthetic */ File generateMigrationScript$default(MigrationUtils migrationUtils, Table[] tableArray, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return migrationUtils.generateMigrationScript(tableArray, string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> statementsRequiredForDatabaseMigration(@NotNull Table[] tables, boolean withLogs) {
        List list;
        Object $this$filter$iv;
        Object $i$f$flatMapTo3;
        Collection thisCollection$iv;
        List<String> list2;
        Object destination$iv$iv3;
        List list3;
        Iterable destination$iv$iv2;
        Iterable thisCollection$iv2;
        List<String> list4;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Table[] $this$partition$iv = tables;
        boolean $i$f$partition = false;
        ArrayList<Table> first$iv = new ArrayList<Table>();
        Object second$iv = new ArrayList<Table>();
        int n = $this$partition$iv.length;
        for (int i = 0; i < n; ++i) {
            Table element$iv;
            Table it = element$iv = $this$partition$iv[i];
            boolean bl = false;
            boolean bl2 = !MetadataQueriesKt.exists(it) ? first$iv.add(element$iv) : ((ArrayList)second$iv).add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List tablesToCreate = (List)pair.component1();
        List tablesToAlter = (List)pair.component2();
        second$iv = this;
        Object message$iv = "Preparing create tables statements";
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToCreate;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv3 = $this$toTypedArray$iv;
            Table[] tableArray = thisCollection$iv3.toArray(new Table[0]);
            List<String> answer$iv = SchemaUtils.INSTANCE.createStatements(Arrays.copyOf(tableArray, tableArray.length));
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list4 = answer$iv;
        } else {
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToCreate;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv2 = $this$toTypedArray$iv;
            Table[] tableArray = thisCollection$iv2.toArray(new Table[0]);
            list4 = SchemaUtils.INSTANCE.createStatements(Arrays.copyOf(tableArray, tableArray.length));
        }
        List<String> createStatements = list4;
        message$iv = this;
        Object message$iv2 = "Preparing create sequences statements";
        boolean $i$f$logTimeSpent2 = false;
        if (withLogs) {
            void $this$flatMapTo$iv$iv;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Iterable $this$flatMap$iv = INSTANCE.checkMissingSequences(Arrays.copyOf(tables, tables.length), withLogs);
            boolean $i$f$flatMap = false;
            thisCollection$iv2 = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Iterator element$iv$iv : $this$flatMapTo$iv$iv) {
                Sequence it = (Sequence)((Object)element$iv$iv);
                boolean bl3 = false;
                Iterable list$iv$iv = it.createStatement();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv2;
            SQLLogKt.getExposedLogger().info((String)message$iv2 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list3 = answer$iv;
        } else {
            void $this$flatMapTo$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv = INSTANCE.checkMissingSequences(Arrays.copyOf(tables, tables.length), withLogs);
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = $this$flatMap$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo3 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Sequence it = (Sequence)element$iv$iv;
                boolean bl4 = false;
                Iterable list$iv$iv = it.createStatement();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            list3 = (List)destination$iv$iv3;
        }
        List createSequencesStatements = list3;
        message$iv2 = this;
        Object message$iv3 = "Preparing alter tables statements";
        boolean $i$f$logTimeSpent3 = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv4 = $this$toTypedArray$iv;
            destination$iv$iv3 = thisCollection$iv4.toArray(new Table[0]);
            List<String> answer$iv = INSTANCE.addMissingAndDropUnmappedColumns(Arrays.copyOf(destination$iv$iv3, ((Table[])destination$iv$iv3).length), withLogs);
            SQLLogKt.getExposedLogger().info((String)message$iv3 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list2 = answer$iv;
        } else {
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            $i$f$flatMapTo3 = thisCollection$iv.toArray(new Table[0]);
            list2 = INSTANCE.addMissingAndDropUnmappedColumns(Arrays.copyOf($i$f$flatMapTo3, ((Table[])$i$f$flatMapTo3).length), withLogs);
        }
        List<String> alterStatements = list2;
        message$iv3 = this;
        String message$iv4 = "Checking mapping consistence";
        boolean $i$f$logTimeSpent4 = false;
        if (withLogs) {
            void $this$filterTo$iv$iv;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray22 = false;
            thisCollection$iv = $this$toTypedArray$iv;
            $i$f$flatMapTo3 = thisCollection$iv.toArray(new Table[0]);
            $i$f$flatMapTo3 = INSTANCE.mappingConsistenceRequiredStatements(Arrays.copyOf($i$f$flatMapTo3, ((Table[])$i$f$flatMapTo3).length), withLogs);
            boolean $i$f$filter = false;
            Object $i$f$toTypedArray22 = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                if (!(!CollectionsKt.plus((Collection)createStatements, (Iterable)alterStatements).contains(it))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv3;
            SQLLogKt.getExposedLogger().info(message$iv4 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list = answer$iv;
        } else {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray32 = false;
            thisCollection$iv = $this$toTypedArray$iv;
            $this$filter$iv = thisCollection$iv.toArray(new Table[0]);
            $this$filter$iv = INSTANCE.mappingConsistenceRequiredStatements(Arrays.copyOf($this$filter$iv, ((Table[])$this$filter$iv).length), withLogs);
            boolean $i$f$filter = false;
            Object $i$f$toTypedArray32 = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl6 = false;
                if (!(!CollectionsKt.plus((Collection)createStatements, (Iterable)alterStatements).contains(it))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list = (List)destination$iv$iv3;
        }
        List modifyTablesStatements = list;
        List allStatements = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)createStatements, (Iterable)createSequencesStatements), (Iterable)alterStatements), (Iterable)modifyTablesStatements);
        return allStatements;
    }

    public static /* synthetic */ List statementsRequiredForDatabaseMigration$default(MigrationUtils migrationUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return migrationUtils.statementsRequiredForDatabaseMigration(tableArray, bl);
    }

    private final List<String> addMissingAndDropUnmappedColumns(Table[] tables, boolean withLogs) {
        boolean dbSupportsAlterTableWithDropColumn;
        Map<Table, PrimaryKeyMetadata> map;
        Map<Table, List<ColumnMetadata>> map2;
        if (tables.length == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList statements = new ArrayList();
        SchemaUtilityApi schemaUtilityApi = this;
        Object message$iv = "Extracting table columns";
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Map<Table, List<ColumnMetadata>> answer$iv2 = DatabaseDialectMetadataKt.getCurrentDialectMetadata().tableColumns(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            map2 = answer$iv2;
        } else {
            boolean bl = false;
            map2 = DatabaseDialectMetadataKt.getCurrentDialectMetadata().tableColumns(Arrays.copyOf(tables, tables.length));
        }
        Map<Table, List<ColumnMetadata>> existingTablesColumns = map2;
        message$iv = this;
        String message$iv2 = "Extracting primary keys";
        boolean $i$f$logTimeSpent2 = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Map<Table, PrimaryKeyMetadata> answer$iv = DatabaseDialectMetadataKt.getCurrentDialectMetadata().existingPrimaryKeys(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info(message$iv2 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            map = answer$iv;
        } else {
            boolean bl = false;
            map = DatabaseDialectMetadataKt.getCurrentDialectMetadata().existingPrimaryKeys(Arrays.copyOf(tables, tables.length));
        }
        Map<Table, PrimaryKeyMetadata> existingPrimaryKeys = map;
        JdbcTransaction tr = TransactionManager.Companion.current();
        boolean dbSupportsAlterTableWithAddColumn = tr.getDb().getSupportsAlterTableWithAddColumn();
        Function2 isIncorrectType = MigrationUtils::addMissingAndDropUnmappedColumns$lambda$10;
        int answer$iv2 = tables.length;
        for (int start$iv = 0; start$iv < answer$iv2; ++start$iv) {
            Table table = tables[start$iv];
            Collection collection = statements;
            List list = existingTablesColumns.get(table);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            this.mapMissingColumnStatementsTo(table, collection, list, existingPrimaryKeys.get(table), dbSupportsAlterTableWithAddColumn, isIncorrectType);
        }
        if (dbSupportsAlterTableWithAddColumn) {
            Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> map3;
            SchemaUtilityApi answer$iv2 = this;
            String message$iv3 = "Extracting column constraints";
            boolean $i$f$logTimeSpent3 = false;
            if (withLogs) {
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> answer$iv3 = DatabaseDialectMetadataKt.getCurrentDialectMetadata().columnConstraints(Arrays.copyOf(tables, tables.length));
                SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
                map3 = answer$iv3;
            } else {
                boolean bl = false;
                map3 = DatabaseDialectMetadataKt.getCurrentDialectMetadata().columnConstraints(Arrays.copyOf(tables, tables.length));
            }
            Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> existingColumnConstraints = map3;
            this.mapMissingConstraintsTo((Collection)statements, existingColumnConstraints, Arrays.copyOf(tables, tables.length));
        }
        if (dbSupportsAlterTableWithDropColumn = tr.getDb().getSupportsAlterTableWithDropColumn()) {
            for (Table table : tables) {
                Collection collection = statements;
                List list = existingTablesColumns.get(table);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                this.mapUnmappedColumnStatementsTo(table, collection, list);
            }
        }
        return statements;
    }

    static /* synthetic */ List addMissingAndDropUnmappedColumns$default(MigrationUtils migrationUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return migrationUtils.addMissingAndDropUnmappedColumns(tableArray, bl);
    }

    @NotNull
    public final List<String> dropUnmappedColumnsStatements(@NotNull Table[] tables, boolean withLogs) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        if (tables.length == 0) {
            return CollectionsKt.emptyList();
        }
        List statements = new ArrayList();
        boolean dbSupportsAlterTableWithDropColumn = TransactionManager.Companion.current().getDb().getSupportsAlterTableWithDropColumn();
        if (dbSupportsAlterTableWithDropColumn) {
            Map<Table, List<ColumnMetadata>> map;
            SchemaUtilityApi schemaUtilityApi = this;
            String message$iv = "Extracting table columns";
            boolean $i$f$logTimeSpent = false;
            if (withLogs) {
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                Map<Table, List<ColumnMetadata>> answer$iv = DatabaseDialectMetadataKt.getCurrentDialectMetadata().tableColumns(Arrays.copyOf(tables, tables.length));
                SQLLogKt.getExposedLogger().info(message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
                map = answer$iv;
            } else {
                boolean bl = false;
                map = DatabaseDialectMetadataKt.getCurrentDialectMetadata().tableColumns(Arrays.copyOf(tables, tables.length));
            }
            Map<Table, List<ColumnMetadata>> existingTablesColumns = map;
            Table[] $this$forEach$iv = tables;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Table element$iv;
                Table table = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Collection collection = statements;
                List list = existingTablesColumns.get(table);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                INSTANCE.mapUnmappedColumnStatementsTo(table, collection, list);
            }
        }
        return statements;
    }

    public static /* synthetic */ List dropUnmappedColumnsStatements$default(MigrationUtils migrationUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return migrationUtils.dropUnmappedColumnsStatements(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> dropUnmappedIndices(@NotNull Table[] tables, boolean withLogs) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        if (tables.length == 0) {
            return CollectionsKt.emptyList();
        }
        Set<Pair<Table, LinkedHashSet<Column<?>>>> foreignKeyConstraints = DatabaseDialectMetadataKt.getCurrentDialectMetadata().columnConstraints(Arrays.copyOf(tables, tables.length)).keySet();
        Map<Table, List<Index>> existingIndices = DatabaseDialectMetadataKt.getCurrentDialectMetadata().existingIndices(Arrays.copyOf(tables, tables.length));
        List toDrop = (List)this.filterAndLogMissingAndUnmappedIndices(existingIndices, foreignKeyConstraints, true, withLogs, Arrays.copyOf(tables, tables.length)).component2();
        Iterable $this$flatMap$iv = toDrop;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List dropUnmappedIndices$default(MigrationUtils migrationUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return migrationUtils.dropUnmappedIndices(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> dropUnmappedSequences(@NotNull Table[] tables, boolean withLogs) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        if (tables.length == 0) {
            return CollectionsKt.emptyList();
        }
        List<Sequence> sequences = this.checkUnmappedSequences(Arrays.copyOf(tables, tables.length), withLogs);
        Iterable $this$flatMap$iv = sequences;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Sequence it = (Sequence)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List dropUnmappedSequences$default(MigrationUtils migrationUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return migrationUtils.dropUnmappedSequences(tableArray, bl);
    }

    private final List<String> mappingConsistenceRequiredStatements(Table[] tables, boolean withLogs) {
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> foreignKeyConstraints = DatabaseDialectMetadataKt.getCurrentDialectMetadata().columnConstraints(Arrays.copyOf(tables, tables.length));
        Map<Table, List<Index>> existingIndices = DatabaseDialectMetadataKt.getCurrentDialectMetadata().existingIndices(Arrays.copyOf(tables, tables.length));
        Pair<List<Index>, List<Index>> filteredIndices = this.filterAndLogMissingAndUnmappedIndices(existingIndices, foreignKeyConstraints.keySet(), true, withLogs, Arrays.copyOf(tables, tables.length));
        List createMissing = (List)filteredIndices.component1();
        List dropUnmapped = (List)filteredIndices.component2();
        Iterable $this$flatMap$iv = createMissing;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Index)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Index)it).createStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = dropUnmapped;
        Collection collection = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Index)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Index)it).dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.filterAndLogExcessConstraints(foreignKeyConstraints, withLogs);
        collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ForeignKeyConstraint)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((ForeignKeyConstraint)it).dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.filterAndLogExcessIndices(existingIndices, withLogs);
        collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Index)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Index)it).dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.checkUnmappedSequences(Arrays.copyOf(tables, tables.length), withLogs);
        collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Sequence)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Sequence)it).dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.checkMissingCheckConstraints(Arrays.copyOf(tables, tables.length), withLogs);
        collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (CheckConstraint)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((CheckConstraint)it).createStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.checkUnmappedCheckConstraints(Arrays.copyOf(tables, tables.length), withLogs);
        collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (CheckConstraint)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((CheckConstraint)it).dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    static /* synthetic */ List mappingConsistenceRequiredStatements$default(MigrationUtils migrationUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return migrationUtils.mappingConsistenceRequiredStatements(tableArray, bl);
    }

    private final List<Sequence> checkMissingSequences(Table[] tables, boolean withLogs) {
        List<Sequence> list;
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSequence()) {
            return CollectionsKt.emptyList();
        }
        Set existingSequencesNames = CollectionsKt.toSet((Iterable)DatabaseDialectMetadataKt.getCurrentDialectMetadata().sequences());
        List<Sequence> it = list = this.filterMissingSequences(existingSequencesNames, Arrays.copyOf(tables, tables.length));
        boolean bl = false;
        INSTANCE.log((Collection)it, "Sequences missed from database (will be created):", withLogs);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Sequence> checkUnmappedSequences(Table[] tables, boolean withLogs) {
        List<Sequence> list;
        List list2;
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSequence()) {
            return CollectionsKt.emptyList();
        }
        if (DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = DatabaseDialectMetadataKt.getCurrentDialectMetadata().existingSequences(Arrays.copyOf(tables, tables.length)).values();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                List it = (List)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = it;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void seq;
                    Sequence sequence = (Sequence)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(seq.getName());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = DatabaseDialectMetadataKt.getCurrentDialectMetadata().sequences();
        }
        Set existingSequencesNames = CollectionsKt.toSet((Iterable)list2);
        List<Sequence> it = list = this.filterUnmappedSequences(existingSequencesNames, Arrays.copyOf(tables, tables.length));
        boolean bl = false;
        INSTANCE.log((Collection)it, "Sequences exist in database and not mapped in code:", withLogs);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CheckConstraint> checkMissingCheckConstraints(Table[] tables, boolean withLogs) {
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsColumnTypeChange()) {
            return CollectionsKt.emptyList();
        }
        List missingCheckConstraints = new ArrayList();
        Table[] $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            CheckConstraint it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Table element$iv;
            Table table = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            List<CheckConstraint> mappedCheckConstraints = table.checkConstraints();
            List list = DatabaseDialectMetadataKt.getCurrentDialectMetadata().existingCheckConstraints(Arrays.copyOf(tables, tables.length)).get(table);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List existingCheckConstraints = list;
            Iterable $this$map$iv = existingCheckConstraints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CheckConstraint checkConstraint = (CheckConstraint)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getCheckName().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                collection.add(string);
            }
            Set existingCheckConstraintsNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $this$map$iv = mappedCheckConstraints;
            collection = missingCheckConstraints;
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (CheckConstraint)element$iv$iv;
                boolean bl3 = false;
                String string = it.getCheckName().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                if (existingCheckConstraintsNames.contains(string)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection.addAll((List)destination$iv$iv);
        }
        this.log(missingCheckConstraints, "CHECK constraints missed from database (will be created):", withLogs);
        return missingCheckConstraints;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CheckConstraint> checkUnmappedCheckConstraints(Table[] tables, boolean withLogs) {
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsColumnTypeChange()) {
            return CollectionsKt.emptyList();
        }
        List unmappedCheckConstraints = new ArrayList();
        Table[] $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            CheckConstraint it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Table element$iv;
            Table table = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            List<CheckConstraint> mappedCheckConstraints = table.checkConstraints();
            List list = DatabaseDialectMetadataKt.getCurrentDialectMetadata().existingCheckConstraints(Arrays.copyOf(tables, tables.length)).get(table);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List existingCheckConstraints = list;
            Iterable $this$map$iv = mappedCheckConstraints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CheckConstraint checkConstraint = (CheckConstraint)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getCheckName().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                collection.add(string);
            }
            Set mappedCheckConstraintsNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $this$map$iv = existingCheckConstraints;
            collection = unmappedCheckConstraints;
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (CheckConstraint)element$iv$iv;
                boolean bl3 = false;
                String string = it.getCheckName().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                if (mappedCheckConstraintsNames.contains(string)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection.addAll((List)destination$iv$iv);
        }
        this.log(unmappedCheckConstraints, "CHECK constraints exist in database and not mapped in code:", withLogs);
        return unmappedCheckConstraints;
    }

    private static final boolean addMissingAndDropUnmappedColumns$lambda$10(ColumnMetadata columnMetadata, Column column) {
        Intrinsics.checkNotNullParameter((Object)columnMetadata, (String)"columnMetadata");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return !DatabaseDialectMetadataKt.getCurrentDialectMetadata().areEquivalentColumnTypes(columnMetadata.getSqlType(), columnMetadata.getJdbcType(), column.getColumnType().sqlType());
    }
}

