/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.common.hud;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import me.jfenn.coordshud.api.IPlaceholderApi;
import me.jfenn.coordshud.api.ITextSerializer;
import me.jfenn.coordshud.common.cache.PlayerCache;
import me.jfenn.coordshud.common.config.CoordsHudConfig;
import me.jfenn.coordshud.common.config.JsonKt;
import me.jfenn.coordshud.common.db.PlayerDao;
import me.jfenn.coordshud.common.db.PlayerRecord;
import me.jfenn.coordshud.common.hud.HudState;
import me.jfenn.coordshud.common.mixinhelper.NetworkMixinHelper;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010%R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010&R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010'R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010(R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010)R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010*R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010+R\u0014\u0010,\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lme/jfenn/coordshud/common/hud/HudController;", "", "Lorg/slf4j/Logger;", "logger", "Lme/jfenn/coordshud/common/db/PlayerDao;", "playerDao", "Lme/jfenn/coordshud/common/cache/PlayerCache;", "cache", "Lme/jfenn/coordshud/api/IPlaceholderApi;", "placeholderApi", "Lme/jfenn/coordshud/api/ITextSerializer;", "textSerializer", "Lme/jfenn/coordshud/common/config/CoordsHudConfig;", "config", "Lme/jfenn/coordshud/common/hud/HudState;", "state", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/coordshud/common/db/PlayerDao;Lme/jfenn/coordshud/common/cache/PlayerCache;Lme/jfenn/coordshud/api/IPlaceholderApi;Lme/jfenn/coordshud/api/ITextSerializer;Lme/jfenn/coordshud/common/config/CoordsHudConfig;Lme/jfenn/coordshud/common/hud/HudState;)V", "Lme/jfenn/coordshud/common/db/PlayerRecord;", "record", "Lnet/minecraft/class_2561;", "getPlayerFormat", "(Lme/jfenn/coordshud/common/db/PlayerRecord;)Lnet/minecraft/class_2561;", "Lnet/minecraft/class_3222;", "player", "getPlayerMessage", "(Lnet/minecraft/class_3222;)Lnet/minecraft/class_2561;", "Lnet/minecraft/server/MinecraftServer;", "server", "", "messageJson", "", "shouldResendTitle", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "", "sendHuds", "(Lnet/minecraft/server/MinecraftServer;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/coordshud/common/db/PlayerDao;", "Lme/jfenn/coordshud/common/cache/PlayerCache;", "Lme/jfenn/coordshud/api/IPlaceholderApi;", "Lme/jfenn/coordshud/api/ITextSerializer;", "Lme/jfenn/coordshud/common/config/CoordsHudConfig;", "Lme/jfenn/coordshud/common/hud/HudState;", "defaultFormat", "Lnet/minecraft/class_2561;", "coordshud-common"})
@SourceDebugExtension(value={"SMAP\nHudController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudController.kt\nme/jfenn/coordshud/common/hud/HudController\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,93:1\n205#2:94\n*S KotlinDebug\n*F\n+ 1 HudController.kt\nme/jfenn/coordshud/common/hud/HudController\n*L\n29#1:94\n*E\n"})
public final class HudController {
    @NotNull
    private final Logger logger;
    @NotNull
    private final PlayerDao playerDao;
    @NotNull
    private final PlayerCache cache;
    @NotNull
    private final IPlaceholderApi placeholderApi;
    @NotNull
    private final ITextSerializer textSerializer;
    @NotNull
    private final CoordsHudConfig config;
    @NotNull
    private final HudState state;
    @NotNull
    private final class_2561 defaultFormat;

    /*
     * WARNING - void declaration
     */
    public HudController(@NotNull Logger logger, @NotNull PlayerDao playerDao, @NotNull PlayerCache cache, @NotNull IPlaceholderApi placeholderApi, @NotNull ITextSerializer textSerializer, @NotNull CoordsHudConfig config, @NotNull HudState state) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)playerDao, (String)"playerDao");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)placeholderApi, (String)"placeholderApi");
        Intrinsics.checkNotNullParameter((Object)textSerializer, (String)"textSerializer");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.logger = logger;
        this.playerDao = playerDao;
        this.cache = cache;
        this.placeholderApi = placeholderApi;
        this.textSerializer = textSerializer;
        this.config = config;
        this.state = state;
        Json json = JsonKt.getJson();
        JsonElement value$iv = this.config.getDefaultFormat();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        this.defaultFormat = this.textSerializer.fromJson(this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv));
        ServerTickEvents.START_SERVER_TICK.register(arg_0 -> HudController._init_$lambda$1(this, arg_0));
    }

    private final class_2561 getPlayerFormat(PlayerRecord record) {
        Object object = this.cache.getPlayerFormats().get((Object)record.getUuid(), () -> HudController.getPlayerFormat$lambda$0(record, this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (class_2561)object;
    }

    private final class_2561 getPlayerMessage(class_3222 player) {
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        PlayerRecord record = this.playerDao.getPlayer(uUID);
        if (!record.isEnabled(this.config)) {
            return null;
        }
        class_2561 format = this.getPlayerFormat(record);
        return this.placeholderApi.parseText(format, player);
    }

    private final boolean shouldResendTitle(MinecraftServer server, class_3222 player, String messageJson) {
        Pair<Integer, String> pair = this.state.getTitleTracker().get(player);
        if (pair == null) {
            return true;
        }
        Pair<Integer, String> pair2 = pair;
        int prevTicks = ((Number)pair2.component1()).intValue();
        String prevMessage = (String)pair2.component2();
        return (prevTicks + 30 < server.method_3780() || !Intrinsics.areEqual((Object)prevMessage, (Object)messageJson)) && prevTicks + 2 <= server.method_3780();
    }

    private final void sendHuds(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            class_2561 message;
            String messageJson;
            Intrinsics.checkNotNull((Object)player);
            if (Duration.compareTo-LRDsOJo((long)NetworkMixinHelper.INSTANCE.getLastMessage-3nIYWDw(server, player), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)) < 0 || this.getPlayerMessage(player) == null || !this.shouldResendTitle(server, player, messageJson = message.toString())) continue;
            NetworkMixinHelper.INSTANCE.onSendingText(message);
            player.method_7353(message, true);
            ((Map)this.state.getTitleTracker()).put(player, new Pair((Object)server.method_3780(), (Object)messageJson));
        }
        Set<class_3222> set = this.state.getTitleTracker().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
        Set inverseKeys = SetsKt.minus(set, (Iterable)CollectionsKt.toSet((Iterable)list));
        for (class_3222 player : inverseKeys) {
            this.state.getTitleTracker().remove(player);
        }
    }

    private static final class_2561 getPlayerFormat$lambda$0(PlayerRecord $record, HudController this$0) {
        class_2561 class_25612 = $record.getFormatText(this$0.textSerializer, this$0.logger);
        if (class_25612 == null) {
            class_25612 = this$0.defaultFormat;
        }
        return class_25612;
    }

    private static final void _init_$lambda$1(HudController this$0, MinecraftServer server) {
        NetworkMixinHelper.INSTANCE.tick();
        Intrinsics.checkNotNull((Object)server);
        this$0.sendHuds(server);
    }
}

