/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ArrayColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.BlobColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.JsonColumnMarker;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.LiteralOp;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0006J\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0006J\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u000f\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\u0006J\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u0006J\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\r\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0006J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0006J\u000f\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0006J\u001b\u0010\u001b\u001a\u00020\u00042\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/PostgreSQLDataTypeProvider;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "<init>", "()V", "", "byteType", "()Ljava/lang/String;", "floatType", "ulongType", "integerAutoincType", "longAutoincType", "ulongAutoincType", "uuidType", "binaryType", "", "length", "(I)Ljava/lang/String;", "blobType", "Ljava/util/UUID;", "value", "", "uuidToDB", "(Ljava/util/UUID;)Ljava/lang/Object;", "dateTimeType", "jsonBType", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "e", "processForDefaultValue", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;)Ljava/lang/String;", "hexString", "hexToDb", "(Ljava/lang/String;)Ljava/lang/String;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nPostgreSQL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostgreSQL.kt\norg/jetbrains/exposed/v1/core/vendors/PostgreSQLDataTypeProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,474:1\n1#2:475\n*E\n"})
public final class PostgreSQLDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final PostgreSQLDataTypeProvider INSTANCE = new PostgreSQLDataTypeProvider();

    private PostgreSQLDataTypeProvider() {
    }

    @Override
    @NotNull
    public String byteType() {
        return "SMALLINT";
    }

    @Override
    @NotNull
    public String floatType() {
        return "REAL";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "BIGINT";
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return "SERIAL";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "BIGSERIAL";
    }

    @Override
    @NotNull
    public String ulongAutoincType() {
        return "BIGSERIAL";
    }

    @Override
    @NotNull
    public String uuidType() {
        return "uuid";
    }

    @Override
    @NotNull
    public String binaryType() {
        return "bytea";
    }

    @Override
    @NotNull
    public String binaryType(int length) {
        SQLLogKt.getExposedLogger().warn("The length of the binary column is not required.");
        return this.binaryType();
    }

    @Override
    @NotNull
    public String blobType() {
        return "bytea";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value;
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    @NotNull
    public String jsonBType() {
        return "JSONB";
    }

    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Object cast;
        DatabaseDialect databaseDialect;
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof JsonColumnMarker && ((databaseDialect = DatabaseDialectKt.getCurrentDialect()) instanceof H2Dialect ? (H2Dialect)databaseDialect : null) == null) {
            cast = ((JsonColumnMarker)((Object)((LiteralOp)e).getColumnType())).getUsesBinaryFormat() ? "::jsonb" : "::json";
            string = super.processForDefaultValue(e) + (String)cast;
        } else if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof BlobColumnType && ((BlobColumnType)((LiteralOp)e).getColumnType()).getUseObjectIdentifier() && ((cast = DatabaseDialectKt.getCurrentDialect()) instanceof H2Dialect ? (H2Dialect)cast : null) == null) {
            string = "lo_from_bytea(0, " + super.processForDefaultValue(e) + " :: bytea)";
        } else if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof ArrayColumnType) {
            String processed;
            String string2;
            String it = string2 = (processed = super.processForDefaultValue(e));
            boolean bl = false;
            string = !Intrinsics.areEqual((Object)it, (Object)"ARRAY[]") ? string2 : null;
            if (string == null) {
                PostgreSQLDataTypeProvider $this$processForDefaultValue_u24lambda_u241 = this;
                boolean bl2 = false;
                String string3 = ((ArrayColumnType)((LiteralOp)e).getColumnType()).getDelegateType().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                String cast2 = string3;
                string = processed + "::" + cast2 + "[]";
            }
        } else {
            string = super.processForDefaultValue(e);
        }
        return string;
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        return "E'\\\\x" + hexString + '\'';
    }
}

