/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.coordshud.api.IPlaceholderApi;
import me.jfenn.coordshud.api.ITextSerializer;
import me.jfenn.coordshud.api.commands.ICommandManager;
import me.jfenn.coordshud.common.cache.PlayerCache;
import me.jfenn.coordshud.common.cache.PlayerCacheController;
import me.jfenn.coordshud.common.commands.CoordsHudCommand;
import me.jfenn.coordshud.common.config.ConfigService;
import me.jfenn.coordshud.common.config.CoordsHudConfig;
import me.jfenn.coordshud.common.db.ConnectionFactory;
import me.jfenn.coordshud.common.db.PlayerDao;
import me.jfenn.coordshud.common.hud.HudController;
import me.jfenn.coordshud.common.hud.HudState;
import me.jfenn.coordshud.common.hud.PlaceholderController;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a-\u0010\t\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/slf4j/Logger;", "logger", "Lme/jfenn/coordshud/api/IPlaceholderApi;", "placeholderApi", "Lme/jfenn/coordshud/api/ITextSerializer;", "textSerializer", "Lme/jfenn/coordshud/api/commands/ICommandManager;", "commandManager", "", "commonModule", "(Lorg/slf4j/Logger;Lme/jfenn/coordshud/api/IPlaceholderApi;Lme/jfenn/coordshud/api/ITextSerializer;Lme/jfenn/coordshud/api/commands/ICommandManager;)V", "coordshud-common"})
public final class CommonModuleKt {
    public static final void commonModule(@NotNull Logger logger, @NotNull IPlaceholderApi placeholderApi, @NotNull ITextSerializer textSerializer, @NotNull ICommandManager commandManager) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)placeholderApi, (String)"placeholderApi");
        Intrinsics.checkNotNullParameter((Object)textSerializer, (String)"textSerializer");
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        Database database = ConnectionFactory.connect$default(new ConnectionFactory(logger), null, 1, null);
        CoordsHudConfig config = new ConfigService(logger).readConfig();
        PlayerCache playerCache = new PlayerCache();
        PlayerDao playerDao = new PlayerDao(database, playerCache);
        new PlayerCacheController(playerCache, playerDao);
        HudState hudState = new HudState();
        new HudController(logger, playerDao, playerCache, placeholderApi, textSerializer, config, hudState);
        new PlaceholderController(placeholderApi);
        new CoordsHudCommand(playerDao, textSerializer, config, hudState, commandManager);
    }
}

