/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core;

import java.nio.ByteBuffer;
import java.sql.Array;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.DatabaseApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Version;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.RowApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Dialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MariaDBDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/UUIDColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnType;", "Ljava/util/UUID;", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "", "value", "valueFromDB", "(Ljava/lang/Object;)Ljava/util/UUID;", "notNullValueToDB", "(Ljava/util/UUID;)Ljava/lang/Object;", "nonNullValueToString", "(Ljava/util/UUID;)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;", "rs", "", "index", "readObject", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;I)Ljava/lang/Object;", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/v1/core/UUIDColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1449:1\n1#2:1450\n*E\n"})
public final class UUIDColumnType
extends ColumnType<UUID> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex uuidRegexp = new Regex("[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}", RegexOption.IGNORE_CASE);

    public UUIDColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @Override
    @NotNull
    public UUID valueFromDB(@NotNull Object value) {
        CharSequence charSequence;
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof UUID) {
            uUID = (UUID)value;
        } else if (value instanceof byte[]) {
            ByteBuffer b = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else if (value instanceof String && uuidRegexp.matches(charSequence = (CharSequence)value)) {
            UUID uUID2 = UUID.fromString((String)value);
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
        } else if (value instanceof String) {
            charSequence = (String)value;
            byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ByteBuffer b = ByteBuffer.wrap(byArray);
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else if (value instanceof ByteBuffer) {
            ByteBuffer b = (ByteBuffer)value;
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return uUID;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        Object object = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if (object == null || (object = ((H2Dialect)object).getOriginalDataTypeProvider()) == null) {
            object = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider();
        }
        return ((DataTypeProvider)object).uuidToDB(value);
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "" + '\'' + value + '\'';
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        DatabaseApi db = CoreTransactionManager.INSTANCE.currentTransaction().getDb();
        if (DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect && !Version.covers$default(db.getVersion(), 10, 0, 0, 6, null)) {
            return rs.getObject(index, Array.class);
        }
        return super.readObject(rs, index);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/UUIDColumnType$Companion;", "", "<init>", "()V", "Lkotlin/text/Regex;", "uuidRegexp", "Lkotlin/text/Regex;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

