/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExpressionKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Function;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IExpressionAlias;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.LiteralOp;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.QueryBuilder;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SortOrder;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLServerDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.exceptions.UnsupportedByDialectException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0006J\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0006J\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u000f\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\u0006J\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u0006J\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0006J\u000f\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0006J\u000f\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0006J\u000f\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0006J\u000f\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0006J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0006J\u000f\u0010\u0019\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0006J\u000f\u0010\u001a\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0006J\u000f\u0010\u001b\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u001b\u0010\u0006J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0017J\u000f\u0010\u001d\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0006J\u000f\u0010\u001e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0006J\u0017\u0010!\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010\u0006J\u000f\u0010$\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b$\u0010\u0006J\u000f\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b%\u0010\u0006J\u000f\u0010&\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b&\u0010\u0006J\u000f\u0010'\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b'\u0010\u0006J\u000f\u0010(\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b(\u0010\u0006J\u0017\u0010+\u001a\u00020\u00042\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010-\u001a\u00020)2\u0006\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b/\u0010\u0006J\u000f\u00100\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b0\u0010\u0006J\u001b\u00103\u001a\u00020\u00042\n\u00102\u001a\u0006\u0012\u0002\b\u000301H\u0016\u00a2\u0006\u0004\b3\u00104J+\u0010;\u001a\u00020:2\u0006\u00106\u001a\u0002052\n\u00107\u001a\u0006\u0012\u0002\b\u0003012\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010>\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H&\u00a2\u0006\u0004\b>\u0010?\u00a8\u0006@"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "", "<init>", "()V", "", "byteType", "()Ljava/lang/String;", "ubyteType", "shortType", "ushortType", "integerType", "uintegerType", "integerAutoincType", "uintegerAutoincType", "longType", "ulongType", "longAutoincType", "ulongAutoincType", "floatType", "doubleType", "", "colLength", "varcharType", "(I)Ljava/lang/String;", "textType", "mediumTextType", "largeTextType", "binaryType", "length", "blobType", "uuidType", "Ljava/util/UUID;", "value", "uuidToDB", "(Ljava/util/UUID;)Ljava/lang/Object;", "dateTimeType", "timestampType", "timestampWithTimeZoneType", "timeType", "dateType", "booleanType", "", "bool", "booleanToStatementString", "(Z)Ljava/lang/String;", "booleanFromStringToBoolean", "(Ljava/lang/String;)Z", "jsonType", "jsonBType", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "e", "processForDefaultValue", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/QueryBuilder;", "queryBuilder", "expression", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/SortOrder;", "sortOrder", "", "precessOrderByClause", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/QueryBuilder;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/SortOrder;)V", "hexString", "hexToDb", "(Ljava/lang/String;)Ljava/lang/String;", "exposed-core"})
public abstract class DataTypeProvider {
    @NotNull
    public String byteType() {
        return "TINYINT";
    }

    @NotNull
    public String ubyteType() {
        return "SMALLINT";
    }

    @NotNull
    public String shortType() {
        return "SMALLINT";
    }

    @NotNull
    public String ushortType() {
        return "INT";
    }

    @NotNull
    public String integerType() {
        return "INT";
    }

    @NotNull
    public String uintegerType() {
        return "BIGINT";
    }

    @NotNull
    public String integerAutoincType() {
        return "INT AUTO_INCREMENT";
    }

    @NotNull
    public String uintegerAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    @NotNull
    public String longType() {
        return "BIGINT";
    }

    @NotNull
    public String ulongType() {
        return "NUMERIC(20)";
    }

    @NotNull
    public String longAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    @NotNull
    public String ulongAutoincType() {
        return "NUMERIC(20) AUTO_INCREMENT";
    }

    @NotNull
    public String floatType() {
        return "FLOAT";
    }

    @NotNull
    public String doubleType() {
        return "DOUBLE PRECISION";
    }

    @NotNull
    public String varcharType(int colLength) {
        return "VARCHAR(" + colLength + ')';
    }

    @NotNull
    public String textType() {
        return "TEXT";
    }

    @NotNull
    public String mediumTextType() {
        return "TEXT";
    }

    @NotNull
    public String largeTextType() {
        return "TEXT";
    }

    @NotNull
    public abstract String binaryType();

    @NotNull
    public String binaryType(int length) {
        return length == Integer.MAX_VALUE ? "VARBINARY(MAX)" : "VARBINARY(" + length + ')';
    }

    @NotNull
    public String blobType() {
        return "BLOB";
    }

    @NotNull
    public String uuidType() {
        return "BINARY(16)";
    }

    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] byArray = ByteBuffer.allocate(16).putLong(value.getMostSignificantBits()).putLong(value.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @NotNull
    public String dateTimeType() {
        return "DATETIME";
    }

    @NotNull
    public String timestampType() {
        return this.dateTimeType();
    }

    @NotNull
    public String timestampWithTimeZoneType() {
        return "TIMESTAMP WITH TIME ZONE";
    }

    @NotNull
    public String timeType() {
        return "TIME";
    }

    @NotNull
    public String dateType() {
        return "DATE";
    }

    @NotNull
    public String booleanType() {
        return "BOOLEAN";
    }

    @NotNull
    public String booleanToStatementString(boolean bool) {
        String string = String.valueOf(bool).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Boolean.parseBoolean(value);
    }

    @NotNull
    public String jsonType() {
        return "JSON";
    }

    @NotNull
    public String jsonBType() {
        throw new UnsupportedByDialectException("This vendor does not support binary JSON data type", DatabaseDialectKt.getCurrentDialect());
    }

    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp) {
            IColumnType iColumnType = ((LiteralOp)e).getColumnType();
            Intrinsics.checkNotNull(iColumnType, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.IColumnType<kotlin.Any?>");
            string = iColumnType.valueAsDefaultString(((LiteralOp)e).getValue());
        } else {
            string = e instanceof Function ? String.valueOf(e) : (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect ? String.valueOf(e) : (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect ? String.valueOf(e) : "" + '(' + e + ')'));
        }
        return string;
    }

    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Object[] objectArray = new Object[3];
        Object object = expression instanceof IExpressionAlias ? (IExpressionAlias)((Object)expression) : null;
        if (object == null || (object = object.getAlias()) == null) {
            object = expression;
        }
        objectArray[0] = object;
        objectArray[1] = " ";
        objectArray[2] = sortOrder.getCode();
        ExpressionKt.append(queryBuilder, objectArray);
    }

    @NotNull
    public abstract String hexToDb(@NotNull String var1);
}

