/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Column;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnDiff;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Function;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Index;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.LiteralOp;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Op;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.QueryBuilder;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ReferenceOption;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Schema;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Table;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Transaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.IdentifierManagerApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.FunctionProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.OracleDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLServerDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLiteDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0001=B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\u00020\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\rJ7\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ)\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020#2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b$\u0010%J=\u0010*\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00022\u001a\u0010)\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0(\"\u0006\u0012\u0002\b\u00030\u001fH\u0016\u00a2\u0006\u0004\b*\u0010+R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010,\u001a\u0004\b-\u0010.R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010/\u001a\u0004\b0\u00101R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00102\u001a\u0004\b3\u00104R\u0014\u00108\u001a\u0002058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u001a\u00109\u001a\u00020\u001a8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\u00a8\u0006>"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DatabaseDialect;", "", "name", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "dataTypeProvider", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "functionProvider", "<init>", "(Ljava/lang/String;Lorg/jetbrains/exposed/v1/core/vendors/DataTypeProvider;Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;)V", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;", "index", "filterCondition", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Function;", "function", "indexFunctionToString", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Function;)Ljava/lang/String;", "createIndex", "table", "columns", "type", "createIndexWithType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "tableName", "indexName", "", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;", "column", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnDiff;", "columnDiff", "", "modifyColumn", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnDiff;)Ljava/util/List;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;", "pkName", "", "pkColumns", "addPrimaryKey", "(Lorg/jetbrains/exposed/v1/core/Table;Ljava/lang/String;[Lorg/jetbrains/exposed/v1/core/Column;)Ljava/lang/String;", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi;", "identifierManager", "supportsMultipleGeneratedKeys", "Z", "getSupportsMultipleGeneratedKeys", "()Z", "DialectNameProvider", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nVendorDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VendorDialect.kt\norg/jetbrains/exposed/v1/core/vendors/VendorDialect\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public abstract class VendorDialect
implements DatabaseDialect {
    @NotNull
    private final String name;
    @NotNull
    private final DataTypeProvider dataTypeProvider;
    @NotNull
    private final FunctionProvider functionProvider;
    private final boolean supportsMultipleGeneratedKeys;

    public VendorDialect(@NotNull String name, @NotNull DataTypeProvider dataTypeProvider, @NotNull FunctionProvider functionProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dataTypeProvider, (String)"dataTypeProvider");
        Intrinsics.checkNotNullParameter((Object)functionProvider, (String)"functionProvider");
        this.name = name;
        this.dataTypeProvider = dataTypeProvider;
        this.functionProvider = functionProvider;
        this.supportsMultipleGeneratedKeys = true;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DataTypeProvider getDataTypeProvider() {
        return this.dataTypeProvider;
    }

    @Override
    @NotNull
    public FunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    @NotNull
    protected final IdentifierManagerApi getIdentifierManager() {
        return CoreTransactionManager.INSTANCE.currentTransaction().getDb().getIdentifierManager();
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Nullable
    public final String filterCondition(@NotNull Index index) {
        Op<Boolean> op;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                op = index.getFilterCondition();
                if (op == null) break block4;
                Op<Boolean> it = op;
                boolean bl = false;
                DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
                if (!(databaseDialect instanceof PostgreSQLDialect || databaseDialect instanceof SQLServerDialect || databaseDialect instanceof SQLiteDialect)) {
                    SQLLogKt.getExposedLogger().warn("Index creation with a filter condition is not supported in " + DatabaseDialectKt.getCurrentDialect().getName());
                    return null;
                }
                String string = new QueryBuilder(false).append(" WHERE ").append((Expression)it).toString();
                op = string;
                if (string != null) break block5;
            }
            op = "";
        }
        return op;
    }

    private final String indexFunctionToString(Function<?> function) {
        String string;
        String baseString = function.toString();
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        if (databaseDialect instanceof SQLiteDialect || databaseDialect instanceof OracleDialect) {
            CharSequence charSequence = baseString;
            Regex regex = new Regex("^*[^( ]*\\.");
            String string2 = "";
            string = regex.replace(charSequence, string2);
        } else {
            string = databaseDialect instanceof MysqlDialect ? (StringsKt.first((CharSequence)baseString) != '(' ? '(' + baseString + ')' : baseString) : baseString;
        }
        return string;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Transaction t = CoreTransactionManager.INSTANCE.currentTransaction();
        String quotedTableName = t.identity(index.getTable());
        String quotedIndexName = t.getDb().getIdentifierManager().cutIfNecessaryAndQuote(index.getIndexName());
        List<ExpressionWithColumnType<?>> list = index.getFunctions();
        List keyFields = CollectionsKt.plus((Collection)index.getColumns(), (Iterable)(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList()));
        String fieldsList = CollectionsKt.joinToString$default((Iterable)keyFields, null, (CharSequence)"(", (CharSequence)")", (int)0, null, arg_0 -> VendorDialect.createIndex$lambda$1(t, this, arg_0), (int)25, null);
        List<ExpressionWithColumnType<?>> list2 = index.getFunctions();
        boolean includesOnlyColumns = !(list2 != null ? !list2.isEmpty() : false);
        String string = this.filterCondition(index);
        if (string == null) {
            return "";
        }
        String maybeFilterCondition = string;
        return index.getUnique() && ((CharSequence)maybeFilterCondition).length() == 0 && includesOnlyColumns ? "ALTER TABLE " + quotedTableName + " ADD CONSTRAINT " + quotedIndexName + " UNIQUE " + fieldsList : (index.getUnique() ? "CREATE UNIQUE INDEX " + quotedIndexName + " ON " + quotedTableName + ' ' + fieldsList + maybeFilterCondition : (index.getIndexType() != null ? this.createIndexWithType(quotedIndexName, quotedTableName, fieldsList, index.getIndexType(), maybeFilterCondition) : "CREATE INDEX " + quotedIndexName + " ON " + quotedTableName + ' ' + fieldsList + maybeFilterCondition));
    }

    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns, @NotNull String type, @NotNull String filterCondition) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)filterCondition, (String)"filterCondition");
        return "CREATE INDEX " + name + " ON " + table + ' ' + columns + " USING " + type + filterCondition;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP CONSTRAINT " + this.getIdentifierManager().cutIfNecessaryAndQuote(indexName);
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        return CollectionsKt.listOf((Object)("ALTER TABLE " + CoreTransactionManager.INSTANCE.currentTransaction().identity(column.getTable()) + " MODIFY COLUMN " + column.descriptionDdl(true)));
    }

    @Override
    @NotNull
    public String addPrimaryKey(@NotNull Table table, @Nullable String pkName, Column<?> ... pkColumns) {
        String string;
        String columns;
        Transaction transaction;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Intrinsics.checkNotNullParameter(pkColumns, (String)"pkColumns");
                transaction = CoreTransactionManager.INSTANCE.currentTransaction();
                columns = ArraysKt.joinToString$default((Object[])pkColumns, null, (CharSequence)"(", (CharSequence)")", (int)0, null, arg_0 -> VendorDialect.addPrimaryKey$lambda$2(transaction, arg_0), (int)25, null);
                string = pkName;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = " CONSTRAINT " + this.getIdentifierManager().quoteIfNecessary(it) + ' ';
                string = string2;
                if (string2 != null) break block3;
            }
            string = " ";
        }
        String constraint = string;
        return "ALTER TABLE " + transaction.identity(table) + " ADD" + constraint + "PRIMARY KEY " + columns;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return DatabaseDialect.DefaultImpls.getSupportsIfNotExists(this);
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSequence(this);
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return DatabaseDialect.DefaultImpls.getNeedsSequenceToAutoInc(this);
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return DatabaseDialect.DefaultImpls.getDefaultReferenceOption(this);
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return DatabaseDialect.DefaultImpls.getNeedsQuotesWhenSymbolsInNames(this);
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsSequenceAsGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsOnlyIdentifiersInGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return DatabaseDialect.DefaultImpls.getSupportsTernaryAffectedRowValues(this);
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSchema(this);
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return DatabaseDialect.DefaultImpls.getSupportsSubqueryUnions(this);
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return DatabaseDialect.DefaultImpls.getSupportsDualTableConcept(this);
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return DatabaseDialect.DefaultImpls.getSupportsOrderByNullsFirstLast(this);
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return DatabaseDialect.DefaultImpls.getSupportsWindowFrameGroupsMode(this);
    }

    @Override
    public boolean getSupportsOnUpdate() {
        return DatabaseDialect.DefaultImpls.getSupportsOnUpdate(this);
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return DatabaseDialect.DefaultImpls.getSupportsSetDefaultReferenceOption(this);
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return DatabaseDialect.DefaultImpls.getSupportsRestrictReferenceOption(this);
    }

    @Override
    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars() {
        return DatabaseDialect.DefaultImpls.getLikePatternSpecialChars(this);
    }

    @Override
    public boolean getRequiresAutoCommitOnCreateDrop() {
        return DatabaseDialect.DefaultImpls.getRequiresAutoCommitOnCreateDrop(this);
    }

    @Override
    public long getSequenceMaxValue() {
        return DatabaseDialect.DefaultImpls.getSequenceMaxValue(this);
    }

    @Override
    public boolean getSupportsColumnTypeChange() {
        return DatabaseDialect.DefaultImpls.getSupportsColumnTypeChange(this);
    }

    @Override
    public boolean getSupportsSelectForUpdate() {
        return DatabaseDialect.DefaultImpls.getSupportsSelectForUpdate(this);
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        return DatabaseDialect.DefaultImpls.isAllowedAsColumnDefault(this, e);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        return DatabaseDialect.DefaultImpls.createDatabase(this, name);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return DatabaseDialect.DefaultImpls.listDatabases(this);
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        return DatabaseDialect.DefaultImpls.dropDatabase(this, name);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.setSchema(this, schema);
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.createSchema(this, schema);
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        return DatabaseDialect.DefaultImpls.dropSchema(this, schema, cascade);
    }

    @Override
    @Deprecated(message="This method was moved to ExposedDatabaseMetadata and should not be used anymore from here.", replaceWith=@ReplaceWith(expression="currentDialectMetadata.areEquivalentColumnTypes(columnMetadataSqlType, columnMetadataJdbcType, columnType)", imports={}))
    public boolean areEquivalentColumnTypes(@NotNull String columnMetadataSqlType, int columnMetadataJdbcType, @NotNull String columnType) {
        return DatabaseDialect.DefaultImpls.areEquivalentColumnTypes(this, columnMetadataSqlType, columnMetadataJdbcType, columnType);
    }

    private static final CharSequence createIndex$lambda$1(Transaction $t, VendorDialect this$0, ExpressionWithColumnType it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExpressionWithColumnType expressionWithColumnType = it;
        if (expressionWithColumnType instanceof Column) {
            charSequence = $t.identity((Column)it);
        } else if (expressionWithColumnType instanceof Function) {
            charSequence = this$0.indexFunctionToString((Function)it);
        } else if (expressionWithColumnType instanceof LiteralOp) {
            char[] cArray = new char[]{'\"'};
            charSequence = StringsKt.trim((String)String.valueOf(((LiteralOp)it).getValue()), (char[])cArray);
        } else {
            SQLLogKt.getExposedLogger().warn("Unexpected defining key field will be passed as String: " + it);
            charSequence = it.toString();
        }
        return charSequence;
    }

    private static final CharSequence addPrimaryKey$lambda$2(Transaction $transaction, Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $transaction.identity(it);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect$DialectNameProvider;", "", "", "dialectName", "<init>", "(Ljava/lang/String;)V", "Ljava/lang/String;", "getDialectName", "()Ljava/lang/String;", "exposed-core"})
    public static abstract class DialectNameProvider {
        @NotNull
        private final String dialectName;

        public DialectNameProvider(@NotNull String dialectName) {
            Intrinsics.checkNotNullParameter((Object)dialectName, (String)"dialectName");
            this.dialectName = dialectName;
        }

        @NotNull
        public final String getDialectName() {
            return this.dialectName;
        }
    }
}

