/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.BasicBinaryColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/BinaryColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/BasicBinaryColumnType;", "", "length", "<init>", "(I)V", "", "sqlType", "()Ljava/lang/String;", "", "value", "", "validateValueBeforeUpdate", "([B)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "I", "getLength", "exposed-core"})
public class BinaryColumnType
extends BasicBinaryColumnType {
    private final int length;

    public BinaryColumnType(int length) {
        this.length = length;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().binaryType(this.length);
    }

    @Override
    public void validateValueBeforeUpdate(@Nullable byte[] value) {
        int valueLength;
        if (value != null && !((valueLength = value.length) <= this.length)) {
            boolean bl = false;
            String string = "Value can't be stored to database column because exceeds length (" + valueLength + " > " + this.length + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.BinaryColumnType");
        BinaryColumnType cfr_ignored_0 = (BinaryColumnType)other;
        return this.length == ((BinaryColumnType)other).length;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.length;
        return result;
    }
}

