/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.DatabaseApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.InternalApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Transaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.NotInitializedTransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.TransactionManagerApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u000bJ\r\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u0019R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/CoreTransactionManager;", "", "<init>", "()V", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseApi;", "getDefaultDatabase", "()Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseApi;", "getDefaultDatabaseOrFirst", "db", "", "setDefaultDatabase", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseApi;)V", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "getDatabaseManager", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseApi;)Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "manager", "registerDatabaseManager", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseApi;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;)V", "closeAndUnregisterDatabase", "getCurrentThreadManager", "()Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "resetCurrentThreadManager", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;)V", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Transaction;", "currentTransactionOrNull", "()Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Transaction;", "currentTransaction", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "databases", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/util/concurrent/atomic/AtomicReference;", "currentDefaultDatabase", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentHashMap;", "registeredDatabases", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/CoreTransactionManager$TransactionManagerThreadLocal;", "currentThreadManager", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/CoreTransactionManager$TransactionManagerThreadLocal;", "TransactionManagerThreadLocal", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nCoreTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTransactionManager.kt\norg/jetbrains/exposed/v1/core/transactions/CoreTransactionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class CoreTransactionManager {
    @NotNull
    public static final CoreTransactionManager INSTANCE = new CoreTransactionManager();
    @NotNull
    private static final ConcurrentLinkedDeque<DatabaseApi> databases = new ConcurrentLinkedDeque();
    @NotNull
    private static final AtomicReference<DatabaseApi> currentDefaultDatabase = new AtomicReference();
    @NotNull
    private static final ConcurrentHashMap<DatabaseApi, TransactionManagerApi> registeredDatabases = new ConcurrentHashMap();
    @NotNull
    private static final TransactionManagerThreadLocal currentThreadManager = new TransactionManagerThreadLocal();

    private CoreTransactionManager() {
    }

    @Nullable
    public final DatabaseApi getDefaultDatabase() {
        return currentDefaultDatabase.get();
    }

    @Nullable
    public final DatabaseApi getDefaultDatabaseOrFirst() {
        DatabaseApi databaseApi = this.getDefaultDatabase();
        if (databaseApi == null) {
            databaseApi = (DatabaseApi)CollectionsKt.firstOrNull((Iterable)databases);
        }
        return databaseApi;
    }

    public final void setDefaultDatabase(@Nullable DatabaseApi db) {
        currentDefaultDatabase.set(db);
    }

    @Nullable
    public final TransactionManagerApi getDatabaseManager(@NotNull DatabaseApi db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        return registeredDatabases.get(db);
    }

    public final void registerDatabaseManager(@NotNull DatabaseApi db, @NotNull TransactionManagerApi manager) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (this.getDefaultDatabaseOrFirst() == null) {
            currentThreadManager.remove();
        }
        if (!registeredDatabases.containsKey(db)) {
            databases.push(db);
        }
        ((Map)registeredDatabases).put(db, manager);
    }

    public final void closeAndUnregisterDatabase(@NotNull DatabaseApi db) {
        block1: {
            TransactionManagerApi manager;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            TransactionManagerApi transactionManagerApi = manager = this.getDatabaseManager(db);
            if (transactionManagerApi == null) break block1;
            TransactionManagerApi it = transactionManagerApi;
            boolean bl = false;
            registeredDatabases.remove(db);
            databases.remove(db);
            currentDefaultDatabase.compareAndSet(db, null);
            if (currentThreadManager.isInitialized() && Intrinsics.areEqual((Object)INSTANCE.getCurrentThreadManager(), (Object)it)) {
                currentThreadManager.remove();
            }
        }
    }

    @NotNull
    public final TransactionManagerApi getCurrentThreadManager() {
        return currentThreadManager.get();
    }

    public final void resetCurrentThreadManager(@Nullable TransactionManagerApi manager) {
        TransactionManagerApi transactionManagerApi = manager;
        if (transactionManagerApi != null) {
            TransactionManagerApi it = transactionManagerApi;
            boolean bl = false;
            currentThreadManager.set(it);
        } else {
            currentThreadManager.remove();
        }
    }

    @Nullable
    public final Transaction currentTransactionOrNull() {
        return this.getCurrentThreadManager().currentOrNull();
    }

    @NotNull
    public final Transaction currentTransaction() {
        Transaction transaction = this.currentTransactionOrNull();
        if (transaction == null) {
            throw new IllegalStateException("No transaction in context.".toString());
        }
        return transaction;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0019\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u0004R\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/CoreTransactionManager$TransactionManagerThreadLocal;", "Ljava/lang/ThreadLocal;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "<init>", "()V", "get", "()Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "initialValue", "value", "", "set", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;)V", "remove", "", "isInitialized", "Z", "()Z", "setInitialized", "(Z)V", "exposed-core"})
    @SourceDebugExtension(value={"SMAP\nCoreTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTransactionManager.kt\norg/jetbrains/exposed/v1/core/transactions/CoreTransactionManager$TransactionManagerThreadLocal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
    private static final class TransactionManagerThreadLocal
    extends ThreadLocal<TransactionManagerApi> {
        private boolean isInitialized;

        public final boolean isInitialized() {
            return this.isInitialized;
        }

        public final void setInitialized(boolean bl) {
            this.isInitialized = bl;
        }

        @Override
        @NotNull
        public TransactionManagerApi get() {
            Object t = super.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            return (TransactionManagerApi)t;
        }

        @Override
        @NotNull
        protected TransactionManagerApi initialValue() {
            Object object;
            block3: {
                block2: {
                    this.isInitialized = true;
                    object = INSTANCE.getDefaultDatabaseOrFirst();
                    if (object == null) break block2;
                    DatabaseApi it = object;
                    boolean bl = false;
                    TransactionManagerApi transactionManagerApi = (TransactionManagerApi)MapsKt.getValue((Map)registeredDatabases, (Object)it);
                    object = transactionManagerApi;
                    if (transactionManagerApi != null) break block3;
                }
                object = NotInitializedTransactionManager.INSTANCE;
            }
            return object;
        }

        @Override
        public void set(@Nullable TransactionManagerApi value) {
            this.isInitialized = true;
            super.set(value);
        }

        @Override
        public void remove() {
            this.isInitialized = false;
            super.remove();
        }
    }
}

