/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Index;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.LiteralOp;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Version;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.FunctionProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MariaDBDataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MariaDBFunctionProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.VendorDialect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0007\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u001b\u0010\n\u001a\u00020\u00042\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u000e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u00158\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001a8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u0006R\u001a\u0010\"\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\"\u0010 \u001a\u0004\b#\u0010\u0006R\u001b\u0010'\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010\u0006R\u001a\u0010(\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b(\u0010 \u001a\u0004\b)\u0010\u0006R!\u0010/\u001a\u00020*8VX\u0096\u0084\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010%\u0012\u0004\b.\u0010\u0003\u001a\u0004\b,\u0010-\u00a8\u00061"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MariaDBDialect;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MysqlDialect;", "<init>", "()V", "", "isFractionDateTimeSupported", "()Z", "isTimeZoneOffsetSupported", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "e", "isAllowedAsColumnDefault", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;)Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;", "index", "", "createIndex", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;)Ljava/lang/String;", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "dataTypeProvider", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "functionProvider", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "supportsOnlyIdentifiersInGeneratedKeys", "Z", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsCreateSequence$delegate", "Lkotlin/Lazy;", "getSupportsCreateSequence", "supportsCreateSequence", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "", "sequenceMaxValue$delegate", "getSequenceMaxValue", "()J", "getSequenceMaxValue$annotations", "sequenceMaxValue", "Companion", "exposed-core"})
public class MariaDBDialect
extends MysqlDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name = Companion.getDialectName();
    @NotNull
    private final DataTypeProvider dataTypeProvider = MariaDBDataTypeProvider.INSTANCE;
    @NotNull
    private final FunctionProvider functionProvider = MariaDBFunctionProvider.INSTANCE;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsSetDefaultReferenceOption;
    @NotNull
    private final Lazy supportsCreateSequence$delegate = LazyKt.lazy(MariaDBDialect::supportsCreateSequence_delegate$lambda$0);
    private final boolean supportsSequenceAsGeneratedKeys;
    @NotNull
    private final Lazy sequenceMaxValue$delegate = LazyKt.lazy(() -> MariaDBDialect.sequenceMaxValue_delegate$lambda$1(this));
    private static final int SEQUENCE_MIN_MAJOR_VERSION = 10;
    private static final int SEQUENCE_MIN_MINOR_VERSION = 3;

    public MariaDBDialect() {
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DataTypeProvider getDataTypeProvider() {
        return this.dataTypeProvider;
    }

    @Override
    @NotNull
    public FunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    @Override
    public boolean getSupportsCreateSequence() {
        Lazy lazy = this.supportsCreateSequence$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return this.supportsSequenceAsGeneratedKeys;
    }

    @Override
    public long getSequenceMaxValue() {
        Lazy lazy = this.sequenceMaxValue$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public static /* synthetic */ void getSequenceMaxValue$annotations() {
    }

    @Override
    public boolean isFractionDateTimeSupported() {
        return Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 5, 3, 0, 4, null);
    }

    @Override
    public boolean isTimeZoneOffsetSupported() {
        return false;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp) {
            return true;
        }
        if (this.getFullVersion$exposed_core().compareTo("10.2.1") >= 0) {
            return true;
        }
        return !this.getNotAcceptableDefaults().contains(((Object)StringsKt.trim((CharSequence)e.toString())).toString());
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getFunctions() != null) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, MariaDBDialect::createIndex$lambda$2, (int)31, null) + " can't be created in MariaDB");
            return "";
        }
        return super.createIndex(index);
    }

    private static final boolean supportsCreateSequence_delegate$lambda$0() {
        return Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 10, 3, 0, 4, null);
    }

    private static final long sequenceMaxValue_delegate$lambda$1(MariaDBDialect this$0) {
        return Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 11, 5, 0, 4, null) ? super.getSequenceMaxValue() : 0x7FFFFFFFFFFFFFFEL;
    }

    private static final CharSequence createIndex$lambda$2(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/MariaDBDialect$Companion;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "", "SEQUENCE_MIN_MAJOR_VERSION", "I", "SEQUENCE_MIN_MINOR_VERSION", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MariaDB");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

