/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.chasmfiend.Chasmfiend;
import us.amon.stormward.worldgen.biome.StormwardBiomes;

public class MeatBlock
extends Block {
    public static final int MIN_SPAWN_RADIUS = 8;
    public static final int MAX_SPAWN_RADIUS = 48;
    private static BlockPattern lurePattern;

    public MeatBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pLevel.m_46791_() != Difficulty.PEACEFUL && pLevel instanceof ServerLevel) {
            Chasmfiend chasmfiend;
            ServerLevel serverLevel = (ServerLevel)pLevel;
            BlockPattern.BlockPatternMatch match = MeatBlock.getOrCreateLurePattern().m_61184_((LevelReader)serverLevel, pPos);
            if (match != null && (chasmfiend = (Chasmfiend)((EntityType)StormwardEntities.CHASMFIEND.get()).m_20615_((Level)serverLevel)) != null) {
                BlockPos lurePos = match.m_61228_();
                BlockPos spawnPos = this.getSpawnLocation((Level)serverLevel, lurePos, chasmfiend, 8);
                if (spawnPos != null) {
                    chasmfiend.m_20219_(Vec3.m_82528_((Vec3i)spawnPos));
                    float rot = Mth.m_14177_((float)((float)Mth.m_14136_((double)(lurePos.m_123343_() - spawnPos.m_123343_()), (double)(lurePos.m_123341_() - spawnPos.m_123341_())) * 57.295776f - 90.0f));
                    chasmfiend.setYRotImmediate(rot);
                    chasmfiend.f_19859_ = rot;
                    chasmfiend.f_20883_ = rot;
                    chasmfiend.f_20884_ = rot;
                    for (ServerPlayer serverplayer : serverLevel.m_45976_(ServerPlayer.class, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)lurePos)).m_82400_(50.0))) {
                        CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)chasmfiend);
                    }
                    chasmfiend.setLurePos(lurePos);
                    chasmfiend.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(pPos), MobSpawnType.TRIGGERED, null, null);
                    serverLevel.m_7967_((Entity)chasmfiend);
                } else {
                    chasmfiend.m_146870_();
                }
            }
        }
    }

    public static BlockPattern getOrCreateLurePattern() {
        if (lurePattern == null) {
            lurePattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"##", "##"}).m_61247_(new String[]{"##", "##"}).m_61244_('#', MeatBlock::blockMatcher).m_61249_();
        }
        return lurePattern;
    }

    public static boolean blockMatcher(BlockInWorld pBlock) {
        return MeatBlock.blockMatcher(pBlock.m_61168_());
    }

    public static boolean blockMatcher(BlockState pState) {
        return pState.m_60734_() instanceof MeatBlock;
    }

    protected BlockPos getSpawnLocation(Level pLevel, BlockPos pLurePos, Chasmfiend pChasmfiend, int pTries) {
        RandomSource random = pChasmfiend.m_217043_();
        int width = Mth.m_14167_((float)((float)Mth.m_14167_((float)pChasmfiend.getBlockBBWidth()) / 2.0f));
        for (int i = 0; i < pTries; ++i) {
            Holder holder;
            int k = (8 + random.m_188503_(40)) * (random.m_188499_() ? -1 : 1);
            int l = (8 + random.m_188503_(40)) * (random.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos pos = pLurePos.m_122032_().m_122184_(k, 0, l);
            pos.m_142448_(this.getHeight(pLevel, pos.m_123341_(), pos.m_123343_()));
            if (!pLevel.m_7232_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_())) || !(holder = pLevel.m_204166_((BlockPos)pos)).m_203565_(StormwardBiomes.SHATTERED_PLAINS)) continue;
            for (int xOffset = -width; xOffset < width; ++xOffset) {
                for (int zOffset = -width; zOffset < width; ++zOffset) {
                    int height = this.getHeight(pLevel, pos.m_123341_() + xOffset, pos.m_123343_() + zOffset);
                    if (pos.m_123342_() >= height) continue;
                    pos.m_142448_(height);
                }
            }
            if (this.isInFluid(pLevel, (BlockPos)pos, width)) continue;
            return pos.m_7949_();
        }
        return null;
    }

    private int getHeight(Level pLevel, int x, int z) {
        return Math.min(pLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR, x, z), pLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z));
    }

    private boolean isInFluid(Level pLevel, BlockPos pPos, int pWidth) {
        for (int xOffset = -pWidth; xOffset < pWidth; ++xOffset) {
            for (int zOffset = -pWidth; zOffset < pWidth; ++zOffset) {
                if (pLevel.m_6425_(pPos.m_7949_().m_7918_(xOffset, 0, zOffset)).m_76178_()) continue;
                return true;
            }
        }
        return false;
    }

    public static void clearPatternBlocks(Level pLevel, BlockPattern.BlockPatternMatch pPatternMatch) {
        for (int x = 0; x < pPatternMatch.m_155970_(); ++x) {
            for (int y = 0; y < pPatternMatch.m_155971_(); ++y) {
                for (int z = 0; z < pPatternMatch.m_155972_(); ++z) {
                    BlockInWorld block = pPatternMatch.m_61229_(x, y, z);
                    pLevel.m_7731_(block.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    pLevel.m_46796_(2001, block.m_61176_(), Block.m_49956_((BlockState)block.m_61168_()));
                }
            }
        }
    }

    public static void updatePatternBlocks(Level pLevel, BlockPattern.BlockPatternMatch pPatternMatch) {
        for (int x = 0; x < pPatternMatch.m_155970_(); ++x) {
            for (int y = 0; y < pPatternMatch.m_155971_(); ++y) {
                for (int z = 0; z < pPatternMatch.m_155972_(); ++z) {
                    BlockInWorld block = pPatternMatch.m_61229_(x, y, z);
                    pLevel.m_6289_(block.m_61176_(), Blocks.f_50016_);
                }
            }
        }
    }

    public static boolean checkPatternBlocks(Level pLevel, BlockPattern.BlockPatternMatch pPatternMatch) {
        for (int x = 0; x < pPatternMatch.m_155970_(); ++x) {
            for (int y = 0; y < pPatternMatch.m_155971_(); ++y) {
                for (int z = 0; z < pPatternMatch.m_155972_(); ++z) {
                    BlockInWorld block = pPatternMatch.m_61229_(x, y, z);
                    if (MeatBlock.blockMatcher(pLevel.m_8055_(block.m_61176_()))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

