/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.stormlightstorage.StormlightStorageBlock;
import us.amon.stormward.blockentity.SphereCageEntity;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.gemstone.Gemstone;

public class SphereCageBlock
extends StormlightStorageBlock<SphereCageEntity>
implements SimpleWaterloggedBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Gemstone> GEMSTONE = EnumProperty.m_61587_((String)"gemstone", Gemstone.class);
    protected static final VoxelShape AABB = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    protected static final VoxelShape HANGING_AABB = Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);

    protected SphereCageBlock(BlockBehaviour.Properties pProperties) {
        super(0, StormwardBlockEntities.SPHERE_CAGE, pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.FALSE)).m_61124_(GEMSTONE, (Comparable)((Object)Gemstone.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        for (Direction direction : pContext.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return (Boolean)pState.m_61143_((Property)HANGING) != false ? HANGING_AABB : AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HANGING, GEMSTONE, WATERLOGGED});
    }

    public boolean m_7898_(@NotNull BlockState pState, @NotNull LevelReader pLevel, BlockPos pPos) {
        Direction direction = SphereCageBlock.getConnectedDirection(pState).m_122424_();
        return Block.m_49863_((LevelReader)pLevel, (BlockPos)pPos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    public BlockState m_7417_(BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return SphereCageBlock.getConnectedDirection(pState).m_122424_() == pDirection && !pState.m_60710_((LevelReader)pLevel, pPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    protected static Direction getConnectedDirection(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }
}

