/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.blockentity.StormDetectorBlockEntity;
import us.amon.stormward.blockentity.StormwardBlockEntities;

public class StormDetectorBlock
extends BaseEntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty INVERTED = BlockStateProperties.f_61441_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public StormDetectorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    public boolean m_7923_(@NotNull BlockState pState) {
        return true;
    }

    public int m_6378_(BlockState pBlockState, @NotNull BlockGetter pBlockAccess, @NotNull BlockPos pPos, @NotNull Direction pSide) {
        return (Integer)pBlockState.m_61143_((Property)POWER);
    }

    private static void updateSignalStrength(BlockState pState, Level pLevel, BlockPos pPos) {
        int power = Mth.m_14143_((float)(((Boolean)pState.m_61143_((Property)INVERTED) != false ? 1.0f - pLevel.f_46438_ : pLevel.f_46438_) * 15.0f));
        if ((Integer)pState.m_61143_((Property)POWER) != power) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pPlayer.m_36326_()) {
            if (pLevel.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate = (BlockState)pState.m_61122_((Property)INVERTED);
            pLevel.m_7731_(pPos, blockstate, 2);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)blockstate));
            StormDetectorBlock.updateSignalStrength(blockstate, pLevel, pPos);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_7899_(@NotNull BlockState pState) {
        return true;
    }

    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new StormDetectorBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return !pLevel.f_46443_ && pLevel.m_6042_().f_223549_() ? StormDetectorBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)StormwardBlockEntities.STORM_DETECTOR.get()), StormDetectorBlock::tickEntity) : null;
    }

    private static void tickEntity(Level p_153113_, BlockPos p_153114_, BlockState p_153115_, StormDetectorBlockEntity p_153116_) {
        if (p_153113_.m_46467_() % 20L == 0L) {
            StormDetectorBlock.updateSignalStrength(p_153115_, p_153113_, p_153114_);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{POWER, INVERTED});
    }
}

