/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public abstract class StormwardEntityBlock<T extends BlockEntity>
extends BaseEntityBlock {
    private final RegistryObject<BlockEntityType<T>> entityType;

    protected StormwardEntityBlock(RegistryObject<BlockEntityType<T>> pEntityType, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.entityType = pEntityType;
    }

    protected BlockEntityType<T> getEntityType() {
        return (BlockEntityType)this.entityType.get();
    }

    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return this.getEntityType().m_155264_(pPos, pState);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity entity;
        if (!pState.m_60713_(pNewState.m_60734_()) && (entity = pLevel.m_7702_(pPos)) != null) {
            entity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)itemHandler.getStackInSlot(i));
                }
            });
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            if (pLevel.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                serverPlayer.openMenu(provider, pPos);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean m_7278_(@NotNull BlockState pState) {
        return true;
    }

    public int m_6782_(@NotNull BlockState pBlockState, Level pLevel, @NotNull BlockPos pPos) {
        BlockEntity entity = pLevel.m_7702_(pPos);
        if (entity == null) {
            return 0;
        }
        return entity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            float f = 0.0f;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack itemstack = itemHandler.getStackInSlot(i);
                if (itemstack.m_41619_()) continue;
                f += (float)itemstack.m_41613_() / (float)Math.min(itemHandler.getSlotLimit(i), itemstack.m_41741_());
            }
            return Mth.m_295919_((float)(f /= (float)itemHandler.getSlots()), (int)0, (int)15);
        }).orElse(0);
    }
}

