/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.ascender;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.ascender.IAscenderBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.ascender.AscenderWinchEntity;

public class AscenderWinchBlock
extends BaseEntityBlock
implements IAscenderBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public AscenderWinchBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_278166_(PushReaction.BLOCK));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return AABB;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        AscenderWinchEntity entity = this.getBlockEntity(pLevel, pPos);
        if (entity != null && entity.isMoving()) {
            return Shapes.m_83110_((VoxelShape)AABB, (VoxelShape)entity.getCollisionShape(pLevel, pPos));
        }
        return super.m_5939_(pState, pLevel, pPos, pContext);
    }

    private AscenderWinchEntity getBlockEntity(BlockGetter pBlockReader, BlockPos pPos) {
        AscenderWinchEntity winchEntity;
        BlockEntity blockEntity = pBlockReader.m_7702_(pPos);
        return blockEntity instanceof AscenderWinchEntity ? (winchEntity = (AscenderWinchEntity)blockEntity) : null;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return ((BlockEntityType)StormwardBlockEntities.ASCENDER_WINCH.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return AscenderWinchBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)StormwardBlockEntities.ASCENDER_WINCH.get()), AscenderWinchEntity::tick);
    }

    public void m_5707_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        AscenderWinchEntity entity = this.getBlockEntity((BlockGetter)pLevel, pPos);
        if (entity != null && entity.isMoving()) {
            entity.stopMoving();
        }
        this.onWillDestroy(pLevel, pPos, pState, pPlayer);
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_6240_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @javax.annotation.Nullable BlockEntity pTe, @NotNull ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, this.getPlayerDestroyState(), pTe, pStack);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.onWillDestroy(level, pos, state, null);
        super.onBlockExploded(state, level, pos, explosion);
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        AscenderWinchEntity winchEntity;
        BlockEntity blockEntity;
        if (pPlayer.m_21120_(pHand).m_41619_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof AscenderWinchEntity && (winchEntity = (AscenderWinchEntity)blockEntity).getLength() > 0.0f) {
            if (!pLevel.f_46443_) {
                pLevel.m_7696_(pPos, pState.m_60734_(), 0, 0);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_8133_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, int pId, int pParam) {
        BlockEntity blockEntity;
        if (pId == 0 && (blockEntity = pLevel.m_7702_(pPos)) instanceof AscenderWinchEntity) {
            AscenderWinchEntity winchEntity = (AscenderWinchEntity)blockEntity;
            winchEntity.wind();
            return true;
        }
        return super.m_8133_(pState, pLevel, pPos, pId, pParam);
    }
}

