/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.pairedfabrial;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;

public class PairedMovementStructureResolver {
    public static final int MAX_PUSH_DEPTH = 7;
    private final Level level;
    private final BlockPos blockPos;
    private final Direction blockDirection;
    private final boolean extending;
    private final BlockPos startPos;
    private final Direction pushDirection;
    private final List<BlockPos> toPush = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();

    public PairedMovementStructureResolver(Level pLevel, BlockPos pPos, Direction pDirection, boolean pExtending) {
        this.level = pLevel;
        this.blockPos = pPos;
        this.blockDirection = pDirection;
        this.extending = pExtending;
        this.startPos = this.blockPos;
        this.pushDirection = pExtending ? pDirection : pDirection.m_122424_();
    }

    public boolean resolve() {
        this.toPush.clear();
        this.toDestroy.clear();
        BlockState blockstate = this.level.m_8055_(this.startPos);
        if (!PistonBaseBlock.m_60204_((BlockState)blockstate, (Level)this.level, (BlockPos)this.startPos, (Direction)this.pushDirection, (boolean)false, (Direction)this.blockDirection)) {
            if (this.extending && blockstate.m_60811_() == PushReaction.DESTROY) {
                this.toDestroy.add(this.startPos);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.startPos, this.pushDirection)) {
            return false;
        }
        for (int i = 0; i < this.toPush.size(); ++i) {
            BlockPos blockpos = this.toPush.get(i);
            if (!this.level.m_8055_(blockpos).isStickyBlock() || this.addBranchingBlocks(blockpos)) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos pOriginPos, Direction pDirection) {
        BlockState blockstate = this.level.m_8055_(pOriginPos);
        if (this.level.m_46859_(pOriginPos)) {
            return true;
        }
        if (!PistonBaseBlock.m_60204_((BlockState)blockstate, (Level)this.level, (BlockPos)pOriginPos, (Direction)this.pushDirection, (boolean)false, (Direction)pDirection)) {
            return true;
        }
        if (this.toPush.contains(pOriginPos)) {
            return true;
        }
        int i = 1;
        if (i + this.toPush.size() > 7) {
            return false;
        }
        while (blockstate.isStickyBlock()) {
            BlockPos blockpos = pOriginPos.m_5484_(this.pushDirection.m_122424_(), i);
            BlockState oldState = blockstate;
            blockstate = this.level.m_8055_(blockpos);
            if (blockstate.m_60795_() || !oldState.canStickTo(blockstate) || !blockstate.canStickTo(oldState) || !PistonBaseBlock.m_60204_((BlockState)blockstate, (Level)this.level, (BlockPos)blockpos, (Direction)this.pushDirection, (boolean)false, (Direction)this.pushDirection.m_122424_()) || blockpos.equals((Object)this.blockPos)) break;
            if (++i + this.toPush.size() <= 7) continue;
            return false;
        }
        int l = 0;
        for (int i1 = i - 1; i1 >= 0; --i1) {
            this.toPush.add(pOriginPos.m_5484_(this.pushDirection.m_122424_(), i1));
            ++l;
        }
        int j1 = 1;
        while (true) {
            BlockPos blockpos1;
            int j;
            if ((j = this.toPush.indexOf(blockpos1 = pOriginPos.m_5484_(this.pushDirection, j1))) > -1) {
                this.reorderListAtCollision(l, j);
                for (int k = 0; k <= j + l; ++k) {
                    BlockPos blockpos2 = this.toPush.get(k);
                    if (!this.level.m_8055_(blockpos2).isStickyBlock() || this.addBranchingBlocks(blockpos2)) continue;
                    return false;
                }
                return true;
            }
            blockstate = this.level.m_8055_(blockpos1);
            if (blockstate.m_60795_()) {
                return true;
            }
            if (!PistonBaseBlock.m_60204_((BlockState)blockstate, (Level)this.level, (BlockPos)blockpos1, (Direction)this.pushDirection, (boolean)true, (Direction)this.pushDirection) || blockpos1.equals((Object)this.blockPos)) {
                return false;
            }
            if (blockstate.m_60811_() == PushReaction.DESTROY) {
                this.toDestroy.add(blockpos1);
                return true;
            }
            if (this.toPush.size() >= 7) {
                return false;
            }
            this.toPush.add(blockpos1);
            ++l;
            ++j1;
        }
    }

    private void reorderListAtCollision(int pOffsets, int pIndex) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.toPush.subList(0, pIndex));
        list1.addAll(this.toPush.subList(this.toPush.size() - pOffsets, this.toPush.size()));
        list2.addAll(this.toPush.subList(pIndex, this.toPush.size() - pOffsets));
        this.toPush.clear();
        this.toPush.addAll(list);
        this.toPush.addAll(list1);
        this.toPush.addAll(list2);
    }

    private boolean addBranchingBlocks(BlockPos pFromPos) {
        BlockState blockstate = this.level.m_8055_(pFromPos);
        for (Direction direction : Direction.values()) {
            BlockPos blockpos;
            BlockState blockstate1;
            if (direction.m_122434_() == this.pushDirection.m_122434_() || !(blockstate1 = this.level.m_8055_(blockpos = pFromPos.m_121945_(direction))).canStickTo(blockstate) || !blockstate.canStickTo(blockstate1) || this.addBlockLine(blockpos, direction)) continue;
            return false;
        }
        return true;
    }

    public Direction getPushDirection() {
        return this.pushDirection;
    }

    public List<BlockPos> getToPush() {
        return this.toPush;
    }

    public List<BlockPos> getToDestroy() {
        return this.toDestroy;
    }
}

