/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.pairedfabrial;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.Config;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.pairedfabrial.PairedBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.pairedfabrial.SpanswitchEntity;
import us.amon.stormward.capability.StormwardCapabilities;

public class SpanswitchBlock
extends PairedBlock<SpanswitchEntity> {
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)});
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private static final int CHANGE_STRENGTH_COST = 1;

    public SpanswitchBlock(BlockBehaviour.Properties pProperties) {
        super(Config.SPANSWITCH_STORMLIGHT, StormwardBlockEntities.SPANSWITCH, pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DUN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{DUN, POWER});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    public void updateStrengthForBlockAndPair(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockPos pairPos;
        BlockState pairState;
        SpanswitchEntity spanswitchEntity;
        int strength = this.calculateStrength(pLevel, pPos);
        int pairStrength = 0;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof SpanswitchEntity && (spanswitchEntity = (SpanswitchEntity)blockEntity).hasPair() && (pairState = pLevel.m_8055_(pairPos = spanswitchEntity.getPair())).m_60713_((Block)StormwardBlocks.SPANSWITCH.get())) {
            pairStrength = this.calculateStrength(pLevel, pairPos);
            this.updateStrengthForBlock(pLevel, pairPos, pairState, Math.max(strength, pairStrength));
        }
        this.updateStrengthForBlock(pLevel, pPos, pState, Math.max(strength, pairStrength));
    }

    public void updateStrengthForBlock(Level pLevel, BlockPos pPos, BlockState pState) {
        this.updateStrengthForBlock(pLevel, pPos, pState, this.calculateStrength(pLevel, pPos));
    }

    public void updateStrengthForBlock(Level pLevel, BlockPos pPos, BlockState pState, int pStrength) {
        int prevStrength = (Integer)pState.m_61143_((Property)POWER);
        if (prevStrength != pStrength) {
            if (pLevel.m_8055_(pPos) == pState) {
                BlockEntity blockEntity;
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(pStrength)), 2);
                if ((prevStrength <= 0 || pStrength <= 0) && (blockEntity = pLevel.m_7702_(pPos)) instanceof SpanswitchEntity) {
                    SpanswitchEntity spanswitchEntity = (SpanswitchEntity)blockEntity;
                    spanswitchEntity.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlight -> stormlight.extractStormlight(1, false));
                    spanswitchEntity.sendUpdate();
                }
            }
            pLevel.m_46672_(pPos, (Block)this);
        }
    }

    private int calculateStrength(Level pLevel, BlockPos pPos) {
        int signal = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos relativePos = pPos.m_121945_(direction);
            int wireSignal = this.getWireSignal(pLevel.m_8055_(relativePos));
            signal = wireSignal > 0 ? Math.max(signal, wireSignal - 1) : Math.max(signal, pLevel.m_277185_(relativePos, direction));
            if (signal < 15) continue;
            return 15;
        }
        return signal;
    }

    private int getWireSignal(BlockState pState) {
        return pState.m_60713_((Block)this) || pState.m_60713_(Blocks.f_50088_) ? (Integer)pState.m_61143_((Property)POWER) : 0;
    }

    @Override
    public void m_6807_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pOldState.m_60713_(pState.m_60734_()) && !pLevel.f_46443_) {
            this.updateStrengthForBlockAndPair(pLevel, pPos, pState);
        }
    }

    @Override
    public void m_6810_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        SpanswitchEntity spanswitchEntity;
        BlockEntity blockEntity;
        if (!pIsMoving && !pState.m_60713_(pNewState.m_60734_()) && !pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(pPos)) instanceof SpanswitchEntity && (spanswitchEntity = (SpanswitchEntity)blockEntity).hasPair()) {
            BlockPos pairPos = spanswitchEntity.getPair();
            this.updateStrengthForBlock(pLevel, pairPos, pLevel.m_8055_(pairPos));
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public void m_6861_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Block pBlock, @NotNull BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.f_46443_) {
            if (pState.m_60710_((LevelReader)pLevel, pPos)) {
                this.updateStrengthForBlockAndPair(pLevel, pPos, pState);
            } else {
                SpanswitchBlock.m_49950_((BlockState)pState, (Level)pLevel, (BlockPos)pPos);
                pLevel.m_7471_(pPos, false);
            }
        }
    }

    public boolean m_7898_(@NotNull BlockState pState, @NotNull LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        return this.canSurviveOn(pLevel, blockpos, pLevel.m_8055_(blockpos));
    }

    protected boolean canSurviveOn(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return pState.m_60659_((BlockGetter)pLevel, pPos, Direction.UP, SupportType.RIGID);
    }

    public int m_6376_(@NotNull BlockState pBlockState, @NotNull BlockGetter pBlockAccess, @NotNull BlockPos pPos, @NotNull Direction pSide) {
        return pBlockState.m_60746_(pBlockAccess, pPos, pSide);
    }

    public int m_6378_(@NotNull BlockState pBlockState, @NotNull BlockGetter pBlockAccess, @NotNull BlockPos pPos, @NotNull Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)DUN) != false ? 0 : (Integer)pBlockState.m_61143_((Property)POWER);
    }

    public boolean m_7899_(@NotNull BlockState pState) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }
}

