/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.stormlightstorage;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.StormwardEntityBlock;
import us.amon.stormward.blockentity.stormlightstorage.StormlightStorageBlockEntity;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightConfigStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightConfigStorageProvider;
import us.amon.stormward.capability.stormlightstorage.StormlightStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageProvider;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItemHelper;

public abstract class StormlightStorageBlock<T extends StormlightStorageBlockEntity>
extends StormwardEntityBlock<T> {
    public static final BooleanProperty DUN = BooleanProperty.m_61465_((String)"dun");
    protected final int maxStormlight;
    protected final ForgeConfigSpec.ConfigValue<Integer> maxStormlightConfigValue;

    protected StormlightStorageBlock(int pMaxStormlight, RegistryObject<BlockEntityType<T>> pEntityType, BlockBehaviour.Properties pProperties) {
        super(pEntityType, pProperties);
        this.maxStormlight = pMaxStormlight;
        this.maxStormlightConfigValue = null;
    }

    protected StormlightStorageBlock(ForgeConfigSpec.ConfigValue<Integer> pMaxStormlightConfigValue, RegistryObject<BlockEntityType<T>> pEntityType, BlockBehaviour.Properties pProperties) {
        super(pEntityType, pProperties);
        this.maxStormlightConfigValue = pMaxStormlightConfigValue;
        this.maxStormlight = (Integer)pMaxStormlightConfigValue.getDefault();
    }

    public IStormlightStorage initStormlightStorage() {
        if (this.maxStormlightConfigValue != null) {
            return new StormlightConfigStorage(this.maxStormlightConfigValue);
        }
        return new StormlightStorage(this.maxStormlight);
    }

    public StormlightStorageProvider initStormlightStorageProvider() {
        if (this.maxStormlightConfigValue != null) {
            return new StormlightConfigStorageProvider(this.maxStormlightConfigValue);
        }
        return new StormlightStorageProvider(this.maxStormlight);
    }

    public <T2 extends BlockEntity> BlockEntityTicker<T2> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T2> pBlockEntityType) {
        return StormlightStorageBlock.m_152132_(pBlockEntityType, this.getEntityType(), StormlightStorageBlockEntity::tick);
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof StormlightStorageBlockEntity) {
            StormlightStorageBlockEntity storageEntity = (StormlightStorageBlockEntity)blockEntity;
            storageEntity.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(itemStorage -> itemStorage.copy((ICapabilityProvider)pStack));
        }
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        ItemStack stack = super.m_7397_(pLevel, pPos, pState);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof StormlightStorageBlockEntity) {
            StormlightStorageBlockEntity storageEntity = (StormlightStorageBlockEntity)blockEntity;
            stack.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(itemStorage -> itemStorage.copy((ICapabilityProvider)storageEntity));
        }
        stack.m_41751_(StormlightStorageItemHelper.getShareTag(stack));
        return stack;
    }

    public static int dunBlockEmission(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)DUN) != false ? 0 : 7;
    }

    @Override
    public int m_6782_(@NotNull BlockState pBlockState, Level pLevel, @NotNull BlockPos pPos) {
        BlockEntity entity = pLevel.m_7702_(pPos);
        if (entity == null) {
            return 0;
        }
        return entity.getCapability(StormwardCapabilities.STORMLIGHT).map(stormlight -> Mth.m_295919_((float)((float)stormlight.getStormlight() / (float)stormlight.getMaxStormlight()), (int)0, (int)15)).orElse(0);
    }
}

