/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.worldgen.plant;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.AABB;
import us.amon.stormward.block.worldgen.plant.PlantReaction;
import us.amon.stormward.weather.Highstorm;

public interface IRosharanPlant {
    public static final EnumProperty<PlantReaction> PLANT_REACTION = EnumProperty.m_61587_((String)"plant_reaction", PlantReaction.class);
    public static final int REACTION_RATE = 4;

    default public BlockState getStateForPlantPlacement(BlockPlaceContext pContext, BlockState pDefaultBlockState) {
        return this.getStateForPlantPlacement(pContext.m_43725_(), pContext.m_8083_(), pDefaultBlockState);
    }

    default public BlockState getStateForPlantPlacement(Level pLevel, BlockPos pPos, BlockState pDefaultBlockState) {
        if (pDefaultBlockState == null) {
            return null;
        }
        return (BlockState)pDefaultBlockState.m_61124_(PLANT_REACTION, (Comparable)((Object)(this.canExtend(pDefaultBlockState, pLevel, pPos) ? PlantReaction.EXTENDED : PlantReaction.RETRACTED)));
    }

    default public void retract(Level pLevel, BlockPos pPos, BlockState pState) {
        PlantReaction reaction = (PlantReaction)((Object)pState.m_61143_(PLANT_REACTION));
        if (reaction.compareTo(PlantReaction.EXTENDED) <= 0) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(PLANT_REACTION, (Comparable)((Object)(switch (reaction) {
                case PlantReaction.EXTENDED, PlantReaction.EXTENDING_1 -> PlantReaction.RETRACTING_0;
                case PlantReaction.EXTENDING_0 -> PlantReaction.RETRACTING_1;
                default -> reaction;
            }))), 3);
            pLevel.m_186460_(pPos, (Block)this, 4);
        }
    }

    default public void extend(Level pLevel, BlockPos pPos, BlockState pState) {
        PlantReaction reaction = (PlantReaction)((Object)pState.m_61143_(PLANT_REACTION));
        if (reaction.compareTo(PlantReaction.EXTENDED) > 0) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(PLANT_REACTION, (Comparable)((Object)(switch (reaction) {
                case PlantReaction.RETRACTED, PlantReaction.RETRACTING_1 -> PlantReaction.EXTENDING_0;
                case PlantReaction.RETRACTING_0 -> PlantReaction.EXTENDING_1;
                default -> reaction;
            }))), 3);
            pLevel.m_186460_(pPos, (Block)this, 4);
        }
    }

    default public void stepOnPlant(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            this.retract(pLevel, pPos, pState);
        }
    }

    default public void updatePlantState(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pLevel instanceof Level) {
            Level level = (Level)pLevel;
            if (pDirection == Direction.UP && this.isBlocked(pLevel, pState, pPos, pNeighborState, pNeighborPos)) {
                this.retract(level, pPos, pState);
            }
        }
    }

    default public void tickPlant(Level pLevel, BlockPos pPos, BlockState pState) {
        PlantReaction reaction = (PlantReaction)((Object)pState.m_61143_(PLANT_REACTION));
        if (reaction.isMoving()) {
            PlantReaction nextReaction = reaction.next();
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(PLANT_REACTION, (Comparable)((Object)nextReaction)), 3);
            if (nextReaction.isMoving()) {
                pLevel.m_186460_(pPos, (Block)this, 4);
            }
        }
    }

    default public void randomTickPlant(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.canExtend(pState, pLevel, pPos)) {
            this.extend(pLevel, pPos, pState);
        } else {
            this.retract(pLevel, pPos, pState);
        }
    }

    default public boolean canExtend(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockPos above = pPos.m_7494_();
        if (this.isBlocked((LevelAccessor)pLevel, pState, pPos, pLevel.m_8055_(above), above)) {
            return false;
        }
        if (Highstorm.isBlockExposedToHighstorm(pLevel, pPos)) {
            return false;
        }
        AABB aabb = new AABB((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (double)(above.m_123341_() + 1), (double)above.m_123342_() + 0.01, (double)(above.m_123343_() + 1));
        return pLevel.m_45976_(LivingEntity.class, aabb).isEmpty();
    }

    default public boolean isBlocked(LevelAccessor pLevel, BlockState pState, BlockPos pPos, BlockState pAboveState, BlockPos pAbovePos) {
        return LightEngine.m_284282_((BlockGetter)pLevel, (BlockState)pState, (BlockPos)pPos, (BlockState)pAboveState, (BlockPos)pAbovePos, (Direction)Direction.UP, (int)pAboveState.m_60739_((BlockGetter)pLevel, pAbovePos)) >= pLevel.m_7469_() || !pAboveState.m_60819_().m_76178_();
    }

    default public void highstormTick(Level pLevel, BlockPos pPos, BlockState pState) {
        this.retract(pLevel, pPos, pState);
    }
}

