/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.worldgen.plant;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.worldgen.plant.IRosharanPlant;
import us.amon.stormward.block.worldgen.plant.PlantReaction;
import us.amon.stormward.block.worldgen.plant.RosharanBushBlock;
import us.amon.stormward.block.worldgen.plant.StormwardPlantTypes;
import us.amon.stormward.tag.StormwardBlockTags;

public class RosharanDoublePlantBlock
extends DoublePlantBlock
implements IRosharanPlant {
    public RosharanDoublePlantBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PLANT_REACTION, (Comparable)((Object)PlantReaction.EXTENDED))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{PLANT_REACTION});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        return this.getStateForPlantPlacement(pContext, super.m_5573_(pContext));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, @NotNull BlockState pState, @NotNull LivingEntity pPlacer, @NotNull ItemStack pStack) {
        BlockPos blockpos = pPos.m_7494_();
        pLevel.m_7731_(blockpos, this.getStateForPlantPlacement(pLevel, blockpos, RosharanDoublePlantBlock.m_182453_((LevelReader)pLevel, (BlockPos)blockpos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER)))), 3);
    }

    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        if (pState.m_61143_((Property)PLANT_REACTION) == PlantReaction.RETRACTED) {
            return pState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? Shapes.m_83040_() : RosharanBushBlock.SHAPE;
        }
        return super.m_5940_(pState, pLevel, pPos, pContext);
    }

    @Override
    public void retract(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockPos belowPos;
        BlockState belowState;
        Block block;
        IRosharanPlant.super.retract(pLevel, pPos, pState);
        if (pState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (block = (belowState = pLevel.m_8055_(belowPos = pPos.m_7495_())).m_60734_()) instanceof IRosharanPlant) {
            IRosharanPlant below = (IRosharanPlant)block;
            below.retract(pLevel, belowPos, belowState);
        }
    }

    @Override
    public void extend(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockPos belowPos;
        BlockState belowState;
        Block block;
        IRosharanPlant.super.extend(pLevel, pPos, pState);
        if (pState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (block = (belowState = pLevel.m_8055_(belowPos = pPos.m_7495_())).m_60734_()) instanceof IRosharanPlant) {
            IRosharanPlant below = (IRosharanPlant)block;
            below.extend(pLevel, belowPos, belowState);
        }
    }

    public void m_213897_(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        this.tickPlant((Level)pLevel, pPos, pState);
    }

    public boolean m_6724_(BlockState pState) {
        return pState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER;
    }

    public void m_213898_(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        this.randomTickPlant((Level)pLevel, pPos, pState);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        BlockState state = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        if (state.m_61138_((Property)PLANT_REACTION)) {
            this.updatePlantState(state, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        }
        return state;
    }

    public void m_7892_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        if (pState.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            BlockPos abovePos = pPos.m_7494_();
            BlockState aboveState = pLevel.m_8055_(abovePos);
            Block block = aboveState.m_60734_();
            if (block instanceof RosharanDoublePlantBlock) {
                RosharanDoublePlantBlock plant = (RosharanDoublePlantBlock)block;
                plant.stepOnPlant(pLevel, abovePos, aboveState, pEntity);
            }
        } else {
            this.stepOnPlant(pLevel, pPos, pState, pEntity);
        }
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return StormwardPlantTypes.ROSHARAN;
    }

    protected boolean m_6266_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return pState.m_204336_(StormwardBlockTags.CAN_SUPPORT_ROSHARAN_PLANT);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }
}

