/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.worldgen.plateaurun;

import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.tag.StormwardBlockTags;

public class ChrysalisBlock
extends Block {
    public static final int DECAY_DISTANCE = 14;
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)14);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;

    public ChrysalisBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(14))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)DISTANCE) == 14 && (Boolean)pState.m_61143_((Property)PERSISTENT) == false;
    }

    public void m_213898_(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (this.decaying(pState)) {
            pLevel.m_7471_(pPos, false);
        }
    }

    protected boolean decaying(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)PERSISTENT) == false && (Integer)pState.m_61143_((Property)DISTANCE) == 14;
    }

    public void m_213897_(@NotNull BlockState pState, ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        pLevel.m_7731_(pPos, ChrysalisBlock.updateDistance(pState, (LevelAccessor)pLevel, pPos), 3);
    }

    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        int i = ChrysalisBlock.getDistanceAt(pFacingState) + 1;
        if (i != 1 || (Integer)pState.m_61143_((Property)DISTANCE) != i) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    private static BlockState updateDistance(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = 14;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.m_122159_((Vec3i)pPos, direction);
            i = Math.min(i, ChrysalisBlock.getDistanceAt(pLevel.m_8055_((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)pState.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState pNeighbor) {
        return ChrysalisBlock.getOptionalDistanceAt(pNeighbor).orElse(14);
    }

    public static OptionalInt getOptionalDistanceAt(BlockState pState) {
        if (pState.m_204336_(StormwardBlockTags.GEMHEARTS)) {
            return OptionalInt.of(0);
        }
        return pState.m_61138_((Property)DISTANCE) ? OptionalInt.of((Integer)pState.m_61143_((Property)DISTANCE)) : OptionalInt.empty();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{DISTANCE, PERSISTENT});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true));
        return ChrysalisBlock.updateDistance(blockstate, (LevelAccessor)pContext.m_43725_(), pContext.m_8083_());
    }
}

