/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.worldgen.wood;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.worldgen.plant.MarkelLeafBlock;
import us.amon.stormward.tag.StormwardBlockTags;

public class MarkelBranchBlock
extends PipeBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public MarkelBranchBlock(BlockBehaviour.Properties pProperties) {
        super(0.1875f, pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_55148_, f_55149_, f_55150_, f_55151_, f_55152_, f_55153_, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos blockPos = pContext.m_8083_();
        Direction direction = pContext.m_43719_().m_122424_();
        BlockState supportState = level.m_8055_(blockPos.m_121945_(direction));
        BlockState blockState = super.m_5573_(pContext);
        return blockState != null && this.canSupport(supportState) ? (BlockState)((BlockState)blockState.m_61124_((Property)f_55154_.get(direction), (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockPos).m_76152_() == Fluids.f_76193_)) : null;
    }

    protected boolean canSupport(BlockState pState) {
        return pState.m_204336_(StormwardBlockTags.MARKEL_LOGS) || pState.m_60713_((Block)StormwardBlocks.MARKEL_BRANCH.get());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        BooleanProperty property;
        BlockState newState = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (!((Boolean)newState.m_61143_((Property)(property = (BooleanProperty)f_55154_.get(pDirection)))).booleanValue() && this.canConnectTo(pNeighborState, pDirection)) {
            newState = (BlockState)newState.m_61124_((Property)property, (Comparable)Boolean.valueOf(true));
        }
        return newState;
    }

    protected boolean canConnectTo(BlockState pFacingState, Direction pFacing) {
        return pFacingState.m_60713_((Block)StormwardBlocks.MARKEL_LEAF.get()) && pFacingState.m_61143_((Property)MarkelLeafBlock.FACING) == pFacing || pFacingState.m_60713_((Block)StormwardBlocks.MARKEL_BRANCH.get()) && (Boolean)pFacingState.m_61143_((Property)f_55154_.get(pFacing.m_122424_())) != false;
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public void m_213897_(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        MarkelBranchBlock.m_49950_((BlockState)pState, (Level)pLevel, (BlockPos)pPos);
        pLevel.m_7471_(pPos, false);
    }
}

