/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.DuelingPitBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.level.Duels;
import us.amon.stormward.sound.StormwardSoundEvents;

public class DuelingPitEntity
extends BlockEntity {
    public static final int INVENTORY_SLOTS = 64;
    private static final int OPEN_TIME = 20;
    public int delay;
    public boolean empty;
    public boolean boundsVisible;
    private final ItemQueueHandler inventory = new ItemQueueHandler(64);
    private final LazyOptional<ItemQueueHandler> optional = LazyOptional.of(() -> this.inventory);

    public DuelingPitEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.DUELING_PIT.get(), pPos, pBlockState);
        this.boundsVisible = (Boolean)pBlockState.m_61143_((Property)DuelingPitBlock.BOUNDS_VISIBLE);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        this.boundsVisible = (Boolean)newState.m_61143_((Property)DuelingPitBlock.BOUNDS_VISIBLE);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, DuelingPitEntity pBlockEntity) {
        pBlockEntity.tick(pLevel, pPos, pState);
    }

    protected void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.f_46443_ && this.f_58857_ != null && --this.delay <= 0 && ((Boolean)pState.m_61143_((Property)DuelingPitBlock.OPEN)).booleanValue()) {
            this.f_58857_.m_7731_(pPos, (BlockState)pState.m_61124_((Property)DuelingPitBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
            this.f_58857_.m_5594_(null, pPos, (SoundEvent)StormwardSoundEvents.DUELING_PIT_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void startDuel(ServerLevel pLevel) {
        BlockPos pos = this.m_58899_();
        Duels.get(pLevel).startDuel(pos);
    }

    public void popOutItem() {
        this.popOutItem(this.inventory.extractRandomItem());
    }

    public void popOutItem(ItemStack pStack) {
        Level level;
        if (!pStack.m_41619_() && this.f_58857_ != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            Vec3 vec3 = Vec3.m_272021_((Vec3i)pos, (double)0.5, (double)1.0, (double)0.5);
            ItemStack copy = pStack.m_41777_();
            ItemEntity entity = new ItemEntity((Level)serverLevel, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), copy);
            entity.m_32060_();
            serverLevel.m_7967_((Entity)entity);
            BlockState state = this.m_58900_();
            if (!((Boolean)state.m_61143_((Property)DuelingPitBlock.OPEN)).booleanValue()) {
                serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)DuelingPitBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
                serverLevel.m_5594_(null, pos, (SoundEvent)StormwardSoundEvents.DUELING_PIT_OPEN.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
            } else {
                serverLevel.m_5594_(null, pos, (SoundEvent)StormwardSoundEvents.DUELING_PIT_EJECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.delay = 20;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, vec3.f_82479_, vec3.f_82480_ + 0.1, vec3.f_82481_, 6, 0.1, 0.1, 0.1, 0.02);
        }
    }

    public void addItem(ItemStack pStack) {
        this.inventory.addItem(pStack);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory.deserializeNBT(pTag.m_128469_("Inventory"));
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.optional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }

    public AABB getRenderBoundingBox() {
        return this.boundsVisible ? INFINITE_EXTENT_AABB : super.getRenderBoundingBox();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("Empty", this.inventory.isEmpty());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.empty = tag.m_128471_("Empty");
    }

    public class ItemQueueHandler
    implements IItemHandler,
    INBTSerializable<CompoundTag> {
        private final int size;
        private final List<ItemStack> stacks;

        public ItemQueueHandler(int pSize) {
            this.size = pSize;
            this.stacks = new ArrayList<ItemStack>();
        }

        public CompoundTag serializeNBT() {
            ListTag list = new ListTag();
            for (ItemStack stack : this.stacks) {
                CompoundTag tag = new CompoundTag();
                stack.m_41739_(tag);
                list.add((Object)tag);
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Items", (Tag)list);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.stacks.clear();
            ListTag list = nbt.m_128437_("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.m_128728_(i);
                this.stacks.add(ItemStack.m_41712_((CompoundTag)tag));
            }
        }

        public int getSlots() {
            return this.stacks.isEmpty() ? 0 : 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.stacks.isEmpty() ? ItemStack.f_41583_ : this.stacks.get(0);
        }

        @NotNull
        public ItemStack addItem(ItemStack pStack) {
            return this.insertItem(0, pStack, false);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!simulate && !stack.m_41619_()) {
                this.stacks.add(stack);
                if (this.stacks.size() > this.size) {
                    this.stacks.remove(0);
                }
                if (!this.stacks.isEmpty()) {
                    this.sendBlockUpdated();
                }
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem() {
            return this.extractItem(0, 1, false);
        }

        @NotNull
        public ItemStack extractRandomItem() {
            return this.extractItem(DuelingPitEntity.this.f_58857_ != null && !this.stacks.isEmpty() ? ((DuelingPitEntity)DuelingPitEntity.this).f_58857_.f_46441_.m_188503_(this.stacks.size()) : 0, 1, false);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.stacks.size() <= slot) {
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                ItemStack stack = this.stacks.remove(slot);
                if (this.stacks.isEmpty()) {
                    this.sendBlockUpdated();
                }
                return stack;
            }
            return this.stacks.get(slot);
        }

        private void sendBlockUpdated() {
            if (DuelingPitEntity.this.f_58857_ != null && !((DuelingPitEntity)DuelingPitEntity.this).f_58857_.f_46443_) {
                DuelingPitEntity.this.empty = this.isEmpty();
                DuelingPitEntity.this.m_6596_();
                DuelingPitEntity.this.f_58857_.m_7260_(DuelingPitEntity.this.m_58899_(), DuelingPitEntity.this.m_58900_(), DuelingPitEntity.this.m_58900_(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }

        public boolean isEmpty() {
            return this.stacks.isEmpty();
        }
    }
}

