/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.SphereCageBlock;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.stormlightstorage.StormlightStorageBlockEntity;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightItemHandlerStorage;
import us.amon.stormward.gemstone.Gemstone;
import us.amon.stormward.gemstone.IGemstoneProvider;
import us.amon.stormward.menu.SphereCageMenu;
import us.amon.stormward.weather.Highstorm;

public class SphereCageEntity
extends StormlightStorageBlockEntity
implements MenuProvider {
    private final ItemStackHandler inventory = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (SphereCageEntity.this.f_58857_ != null && SphereCageEntity.this.f_58857_.m_8055_(SphereCageEntity.this.m_58899_()).m_60713_((Block)StormwardBlocks.SPHERE_CAGE.get())) {
                SphereCageEntity.this.sendUpdate();
            }
        }
    };
    private final LazyOptional<ItemStackHandler> optional = LazyOptional.of(() -> this.inventory);
    @Nullable
    protected ResourceLocation lootTable;
    protected long lootTableSeed;

    public SphereCageEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.SPHERE_CAGE.get(), pPos, pBlockState);
    }

    @Override
    protected IStormlightStorage initStormlightStorage(BlockState pBlockState) {
        return new StormlightItemHandlerStorage((ICapabilityProvider)this);
    }

    @Override
    protected BlockState updateState(BlockState pState) {
        pState = super.updateState(pState);
        pState = this.updateProperty(pState, SphereCageBlock.GEMSTONE, this.getBrightestGemstone());
        return pState;
    }

    private Gemstone getBrightestGemstone() {
        HashMap brightnesses = new HashMap();
        ArrayList order = new ArrayList();
        this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                stack.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> {
                    Item patt4441$temp;
                    if (!stormlightStorage.isDun() && (patt4441$temp = stack.m_41720_()) instanceof IGemstoneProvider) {
                        IGemstoneProvider lightProvider = (IGemstoneProvider)patt4441$temp;
                        Gemstone gemstone = lightProvider.getGemstone();
                        brightnesses.put(gemstone, brightnesses.getOrDefault((Object)gemstone, 0) + stormlightStorage.getStormlight());
                        order.add(gemstone);
                    }
                });
            }
        });
        Gemstone brightestGemstone = Gemstone.NONE;
        int brightness = 0;
        for (Gemstone gemstone : order) {
            if ((Integer)brightnesses.get((Object)gemstone) <= brightness) continue;
            brightestGemstone = gemstone;
            brightness = (Integer)brightnesses.get((Object)gemstone);
        }
        return brightestGemstone;
    }

    @Override
    public boolean isExposedToHighstorm() {
        BlockPos pos = this.m_58899_();
        if (Highstorm.isBlockExposedToHighstorm(this.f_58857_, pos)) {
            return true;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!Highstorm.isBlockExposedToHighstorm(this.f_58857_, pos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return new SphereCageMenu(pContainerId, pPlayerInventory, this);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.stormward.sphere_cage");
    }

    @NotNull
    public ItemStack getItem(int pSlot) {
        return this.inventory.getStackInSlot(pSlot);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        if (!this.tryLoadLootTable(pTag)) {
            this.inventory.deserializeNBT(pTag.m_128469_("Inventory"));
        }
    }

    public void onLoad() {
        super.onLoad();
        this.unpackLootTable(null);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.trySaveLootTable(pTag)) {
            pTag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.optional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }

    protected boolean tryLoadLootTable(CompoundTag pTag) {
        if (pTag.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(pTag.m_128461_("LootTable"));
            this.lootTableSeed = pTag.m_128454_("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean trySaveLootTable(CompoundTag pTag) {
        if (this.lootTable == null) {
            return false;
        }
        pTag.m_128359_("LootTable", this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            pTag.m_128356_("LootTableSeed", this.lootTableSeed);
        }
        return true;
    }

    public void unpackLootTable(@Nullable Player pPlayer) {
        if (this.lootTable != null && this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            LootTable table = this.f_58857_.m_7654_().m_278653_().m_278676_(this.lootTable);
            if (pPlayer instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)pPlayer, this.lootTable);
            }
            this.lootTable = null;
            LootParams.Builder params = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (pPlayer != null) {
                params.m_287239_(pPlayer.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)pPlayer);
            }
            ObjectArrayList items = table.m_287214_(params.m_287235_(LootContextParamSets.f_81411_), this.f_58858_.m_121878_());
            this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                int i;
                ObjectArrayList slots = new ObjectArrayList();
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    if (itemHandler.getStackInSlot(i) != ItemStack.f_41583_) continue;
                    slots.add((Object)i);
                }
                Util.m_214673_((ObjectArrayList)slots, (RandomSource)this.f_58857_.f_46441_);
                for (i = 0; i < items.size() && !slots.isEmpty(); ++i) {
                    itemHandler.insertItem(((Integer)slots.pop()).intValue(), (ItemStack)items.get(i), false);
                }
            });
        }
    }

    public void setLootTable(ResourceLocation pLootTable, long pLootTableSeed) {
        this.lootTable = pLootTable;
        this.lootTableSeed = pLootTableSeed;
    }
}

