/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.ascender;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import us.amon.stormward.blockentity.ascender.AscenderWinchEntity;

public abstract class AscenderEntity
extends BlockEntity {
    public AscenderEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    protected abstract AscenderWinchEntity getWinchEntity();

    protected abstract int getPosition();

    public float getVerticalOffset(float pPartialTick) {
        return this.getVerticalOffset(pPartialTick, 1.0f);
    }

    public float getVerticalOffset(float pPartialTick, float pInterval) {
        AscenderWinchEntity winch = this.getWinchEntity();
        if (winch != null && winch.isMoving()) {
            return -winch.getLength(pPartialTick) % pInterval;
        }
        return 0.0f;
    }

    @Nullable
    public BlockState getVisualState(float pPartialTick) {
        int position;
        float length;
        AscenderWinchEntity winch = this.getWinchEntity();
        if (winch != null && (length = winch.getLength(pPartialTick)) >= (float)(position = this.getPosition())) {
            return length - 1.0f < (float)position ? winch.getCounterweightState() : winch.getChainState();
        }
        return null;
    }

    public VoxelShape getCollisionShape(BlockGetter pLevel, BlockPos pPos) {
        BlockState visualState = this.getVisualState(0.0f);
        if (visualState == null) {
            return Shapes.m_83040_();
        }
        return visualState.m_60812_(pLevel, pPos).m_83216_(0.0, (double)this.getVerticalOffset(0.0f), 0.0);
    }
}

