/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.pairedfabrial;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.pairedfabrial.OathgateBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.pairedfabrial.PairedBlockEntity;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.level.Oathgates;
import us.amon.stormward.worldgen.dimension.StormwardDimensions;

public class OathgateBlockEntity
extends PairedBlockEntity {
    private BlockPos mirrorPos;

    public OathgateBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.OATHGATE.get(), pPos, pBlockState);
    }

    @Override
    protected IStormlightStorage initStormlightStorage(BlockState pBlockState) {
        return ((OathgateBlock)pBlockState.m_60734_()).initStormlightStorage();
    }

    @Override
    public void sendUpdate(Level pLevel, BlockPos pPos, BlockState pState) {
        super.sendUpdate(pLevel, pPos, pState);
        OathgateBlockEntity mirror = this.getMirror();
        if (mirror != null) {
            mirror.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> {
                if (stormlightStorage.getStormlight() != StormlightStorageHelper.getStormlight((ICapabilityProvider)this)) {
                    boolean dun = stormlightStorage.isDun();
                    stormlightStorage.copy((ICapabilityProvider)this);
                    if (dun != stormlightStorage.isDun()) {
                        mirror.sendUpdate();
                    }
                }
            });
        }
    }

    @Override
    public void onPlace() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.connectOathgates(serverLevel);
        }
    }

    @Override
    public void onRemove() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            OathgateBlockEntity oathgateEntity;
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hasMirror()) {
                this.getMirror().setMirrorPos(null);
                OathgateBlock.getDestination(serverLevel).m_7471_(this.getMirrorPos(), false);
            }
            Oathgates oathgates = Oathgates.get(serverLevel);
            if (this.m_58899_().equals((Object)oathgates.getUnpairedOathgate())) {
                oathgates.setUnpairedOathgate(null);
            } else if (this.hasPair() && (blockEntity = serverLevel.m_7702_(this.getPair())) instanceof OathgateBlockEntity && !(oathgateEntity = (OathgateBlockEntity)blockEntity).connectOathgates(serverLevel)) {
                super.onRemove();
            }
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.mirrorPos = pTag.m_128441_("Mirror") ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("Mirror")) : null;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.mirrorPos != null) {
            pTag.m_128365_("Mirror", (Tag)NbtUtils.m_129224_((BlockPos)this.mirrorPos));
        }
    }

    public boolean hasMirror() {
        return this.mirrorPos != null;
    }

    public BlockPos getMirrorPos() {
        return this.mirrorPos;
    }

    public void setMirrorPos(BlockPos pMirrorPos) {
        ServerLevel serverLevel;
        Oathgates oathgates;
        Level level;
        this.mirrorPos = pMirrorPos;
        if (this.hasMirror() && this.getMirror().hasPair() && (level = this.m_58904_()) instanceof ServerLevel && (oathgates = Oathgates.get(serverLevel = (ServerLevel)level)).getUnpairedOathgate() == this.m_58899_()) {
            oathgates.setUnpairedOathgate(null);
        }
        this.sendUpdate();
    }

    public OathgateBlockEntity getMirror() {
        ServerLevel serverLevel;
        Level level;
        if (this.hasMirror() && (level = this.m_58904_()) instanceof ServerLevel && OathgateBlock.hasDestination((Level)(serverLevel = (ServerLevel)level))) {
            return (OathgateBlockEntity)OathgateBlock.getDestination(serverLevel).m_7702_(this.mirrorPos);
        }
        return null;
    }

    protected boolean connectOathgates(ServerLevel pLevel) {
        BlockPos pos = this.m_58899_();
        BlockState blockState = pLevel.m_8055_(pos);
        Oathgates oathgates = Oathgates.get(pLevel);
        if (oathgates.hasUnpairedOathgate()) {
            BlockState unpairedState;
            BlockPos unpairedPos = oathgates.getUnpairedOathgate();
            if (OathgateBlockEntity.isValidPair((Level)pLevel, pos, blockState, unpairedPos, unpairedState = pLevel.m_8055_(unpairedPos))) {
                this.connectToPair(pos, blockState, unpairedPos, unpairedState);
                oathgates.setUnpairedOathgate(null);
                return true;
            }
            oathgates.setUnpairedOathgate(null);
        } else {
            oathgates.setUnpairedOathgate(pos);
        }
        return false;
    }

    public boolean tryCreateMirror(ServerLevel pLevel) {
        if (!OathgateBlock.hasDestination((Level)pLevel)) {
            return false;
        }
        if (this.hasMirror() && this.getMirror() != null) {
            return true;
        }
        ServerLevel destination = OathgateBlock.getDestination(pLevel);
        BlockPos mirrorPos = StormwardDimensions.convert(this.m_58899_(), (ResourceKey<Level>)destination.m_46472_());
        Oathgates oathgates = Oathgates.get(destination);
        BlockPos unpairedOathgate = oathgates.getUnpairedOathgate();
        if (this.hasPair()) {
            oathgates.setUnpairedOathgate(null);
        }
        if (OathgateBlock.canReplace((Level)destination, mirrorPos) && destination.m_7731_(mirrorPos, this.m_58900_(), 3)) {
            this.setMirrorPos(mirrorPos);
            BlockEntity blockEntity = destination.m_7702_(mirrorPos);
            if (blockEntity instanceof OathgateBlockEntity) {
                OathgateBlockEntity pair;
                BlockEntity blockEntity2;
                OathgateBlockEntity mirror = (OathgateBlockEntity)blockEntity;
                mirror.setMirrorPos(this.m_58899_());
                if (this.hasPair() && (blockEntity2 = pLevel.m_7702_(this.getPair())) instanceof OathgateBlockEntity && (pair = (OathgateBlockEntity)blockEntity2).hasMirror()) {
                    mirror.setPair(pair.getMirrorPos());
                    pair.getMirror().setPair(mirrorPos);
                }
            }
            if (!destination.m_8055_(mirrorPos.m_7495_()).m_60783_((BlockGetter)pLevel, mirrorPos.m_7495_(), Direction.UP)) {
                BlockPos center = OathgateBlock.getPlatformCenter(mirrorPos, this.m_58900_());
                for (BlockPos platformPos : BlockPos.m_121925_((BlockPos)center, (int)6, (int)0, (int)6)) {
                    if (!(platformPos.m_123331_((Vec3i)center) < 36.0) || !OathgateBlock.canReplace((Level)destination, platformPos)) continue;
                    destination.m_7731_(platformPos, Blocks.f_50472_.m_49966_(), 3);
                }
            }
        }
        oathgates.setUnpairedOathgate(unpairedOathgate);
        return this.hasMirror();
    }
}

