/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.DuelingPitBlock;
import us.amon.stormward.blockentity.DuelingPitEntity;

public class DuelingPitRenderer
implements BlockEntityRenderer<DuelingPitEntity> {
    private static final ResourceLocation ARENA_BOUNDS_LOCATION = new ResourceLocation("stormward", "textures/misc/duel_bounds.png");
    public static final List<Vec2> VERTICES = new ArrayList<Vec2>();

    public DuelingPitRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DuelingPitEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        if (pBlockEntity.boundsVisible) {
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARENA_BOUNDS_LOCATION);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.depthMask((boolean)Minecraft.m_91085_());
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.disableCull();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            PoseStack.Pose pose = pPoseStack.m_85850_();
            for (int i = 0; i < VERTICES.size(); ++i) {
                Vec2 vertex = VERTICES.get(i);
                int corner = i % 4;
                boolean x = corner != 0 && corner != 3;
                int y = corner / 2;
                bufferBuilder.m_252986_(pose.m_252922_(), vertex.f_82470_, (float)((1 - y) * 8), vertex.f_82471_).m_7421_((float)x, (float)(y * 8)).m_6122_(y * 255, y * 255, y * 255, 255).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public boolean shouldRenderOffScreen(@NotNull DuelingPitEntity pBlockEntity) {
        return pBlockEntity.boundsVisible;
    }

    public int m_142163_() {
        return 96;
    }

    static {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        DuelingPitBlock.getBlockStream(BlockPos.f_121853_, 0, 0).forEach(pos -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                mutable.m_122159_((Vec3i)pos, direction);
                if (DuelingPitBlock.isInArenaHorizontal(BlockPos.f_121853_, (Vec3i)mutable)) continue;
                float x1 = (float)pos.m_123341_() + 0.5f + (float)direction.m_122429_() * 0.499f - (float)direction.m_122431_() * 0.5f;
                float z1 = (float)pos.m_123343_() + 0.5f + (float)direction.m_122431_() * 0.499f + (float)direction.m_122429_() * 0.5f;
                float x2 = x1 + (float)direction.m_122431_();
                float z2 = z1 - (float)direction.m_122429_();
                VERTICES.add(new Vec2(x1, z1));
                VERTICES.add(new Vec2(x2, z2));
                VERTICES.add(new Vec2(x2, z2));
                VERTICES.add(new Vec2(x1, z1));
            }
        });
    }
}

