/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.stormlightstorage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.stormlightstorage.StormlightStorageBlock;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.weather.Highstorm;

public class StormlightStorageBlockEntity
extends BlockEntity {
    public static final String STORMLIGHT_KEY = "Stormlight";
    private final IStormlightStorage storage;
    private final LazyOptional<IStormlightStorage> optional;

    public StormlightStorageBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.storage = this.initStormlightStorage(pBlockState);
        this.optional = LazyOptional.of(() -> this.storage);
    }

    protected IStormlightStorage initStormlightStorage(BlockState pBlockState) {
        Block block = pBlockState.m_60734_();
        if (block instanceof StormlightStorageBlock) {
            StormlightStorageBlock storageBlock = (StormlightStorageBlock)block;
            return storageBlock.initStormlightStorage();
        }
        return new StormlightStorage(0, 0);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == StormwardCapabilities.STORMLIGHT) {
            return this.optional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }

    public boolean isExposedToHighstorm() {
        return Highstorm.isBlockExposedToHighstorm(this.f_58857_, this.m_58899_());
    }

    public void sendUpdate() {
        if (this.f_58857_ != null) {
            this.sendUpdate(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void sendUpdate(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.m_5776_()) {
            this.m_6596_();
            BlockState updatedState = this.updateState(pState);
            if (!pState.equals(updatedState)) {
                pLevel.m_7731_(pPos, updatedState, 1);
            }
            pLevel.m_7260_(pPos, pState, updatedState, 3);
        }
    }

    protected BlockState updateState(BlockState pState) {
        if (pState.m_61138_((Property)StormlightStorageBlock.DUN)) {
            return this.updateProperty(pState, (Property)StormlightStorageBlock.DUN, StormlightStorageHelper.isDun((ICapabilityProvider)this));
        }
        return pState;
    }

    protected <T extends Comparable<T>> BlockState updateProperty(BlockState pState, Property<T> pProperty, T pValue) {
        if (pState.m_61143_(pProperty) != pValue) {
            return (BlockState)pState.m_61124_(pProperty, pValue);
        }
        return pState;
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.storage.deserializeNBT((Tag)pTag.m_128469_(STORMLIGHT_KEY));
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_(STORMLIGHT_KEY, this.storage.serializeNBT());
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, StormlightStorageBlockEntity pBlockEntity) {
        pBlockEntity.tick(pLevel, pPos, pState);
    }

    protected void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        ServerLevel serverLevel;
        if (pLevel instanceof ServerLevel && this.serverTick(serverLevel = (ServerLevel)pLevel, pPos, pState)) {
            this.sendUpdate(pLevel, pPos, pState);
        }
    }

    protected boolean serverTick(ServerLevel pLevel, BlockPos pPos, BlockState pState) {
        return StormlightStorageHelper.shouldReceiveHighstormStormlight(this) && StormlightStorageHelper.receiveHighstormProvider((ICapabilityProvider)this);
    }
}

