/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.stormlightstorage;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.stormlightstorage.StormlightTransferBlock;
import us.amon.stormward.blockentity.stormlightstorage.StormlightStorageBlockEntity;
import us.amon.stormward.blockentity.stormlightstorage.TransferenceInputEntity;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.particle.StormwardParticles;

public class StormlightTransferBlockEntity
extends StormlightStorageBlockEntity {
    public static final int MAX_DISTANCE = 6;
    private static final int TRANSFER_INTERVAL = 10;
    private static final int TRANSFER_AMOUNT = 10;
    private static final int PARTICLE_INTERVAL = 2;
    private final Set<BlockPos> receiverPositions = new HashSet<BlockPos>();

    public StormlightTransferBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public boolean canExtractStormlight() {
        return !StormlightStorageHelper.isDun((ICapabilityProvider)this);
    }

    public boolean canReceiveStormlight() {
        return !StormlightStorageHelper.isFull((ICapabilityProvider)this);
    }

    public boolean tryAddReceiver(BlockPos pReceiverPos) {
        StormlightTransferBlockEntity receiver;
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return false;
        }
        if (!this.canExtractStormlight() || this.receiverPositions.contains(pReceiverPos) || pReceiverPos.m_123331_((Vec3i)this.m_58899_()) > 36.0) {
            return false;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(pReceiverPos);
        if (blockEntity instanceof StormlightTransferBlockEntity && (receiver = (StormlightTransferBlockEntity)blockEntity) != this && receiver.canReceiveStormlight()) {
            this.receiverPositions.add(pReceiverPos);
            this.sendUpdate();
            return true;
        }
        return false;
    }

    @Override
    protected void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        super.tick(pLevel, pPos, pState);
        if (pLevel.m_5776_()) {
            this.playTransferEffects(pLevel, pPos);
        }
    }

    @Override
    protected boolean serverTick(ServerLevel pLevel, BlockPos pPos, BlockState pState) {
        boolean result = super.serverTick(pLevel, pPos, pState);
        if ((pLevel.m_46467_() + pPos.m_121878_()) % 10L == 0L) {
            boolean isTransferring;
            Iterator<BlockPos> iterator = this.receiverPositions.iterator();
            while (iterator.hasNext()) {
                StormlightTransferBlockEntity receiver;
                BlockEntity blockEntity = pLevel.m_7702_(iterator.next());
                if (blockEntity instanceof StormlightTransferBlockEntity && StormlightStorageHelper.transfer((ICapabilityProvider)this, (ICapabilityProvider)(receiver = (StormlightTransferBlockEntity)blockEntity), 10)) {
                    receiver.sendUpdate();
                } else {
                    iterator.remove();
                }
                result = true;
            }
            if (pState.m_61138_((Property)StormlightTransferBlock.IS_TRANSFERRING) && (isTransferring = this.isTransferring((Level)pLevel, pPos)) != (Boolean)pState.m_61143_((Property)StormlightTransferBlock.IS_TRANSFERRING)) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)StormlightTransferBlock.IS_TRANSFERRING, (Comparable)Boolean.valueOf(isTransferring)));
            }
        }
        return result;
    }

    protected void playTransferEffects(Level pLevel, BlockPos pPos) {
        if (pLevel.m_46467_() % 2L == 0L) {
            Vec3 center = this.getTransferPos();
            for (BlockPos receiverPos : this.receiverPositions) {
                BlockEntity blockEntity = pLevel.m_7702_(receiverPos);
                if (!(blockEntity instanceof StormlightTransferBlockEntity)) continue;
                StormlightTransferBlockEntity transferEntity = (StormlightTransferBlockEntity)blockEntity;
                Vec3 delta = transferEntity.getTransferPos().m_82546_(center);
                pLevel.m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT_TRANSFER.get(), center.f_82479_, center.f_82480_, center.f_82481_, delta.f_82479_, delta.f_82480_, delta.f_82481_);
            }
        }
    }

    private boolean isTransferring(Level pLevel, BlockPos pPos) {
        if (!this.receiverPositions.isEmpty()) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            TransferenceInputEntity outputEntity;
            BlockEntity blockEntity = pLevel.m_7702_(pPos.m_121945_(direction));
            if (!(blockEntity instanceof TransferenceInputEntity) || !(outputEntity = (TransferenceInputEntity)blockEntity).getConnectedBlockPos().equals((Object)pPos) || !outputEntity.isActive) continue;
            return true;
        }
        return false;
    }

    public Vec3 getTransferPos() {
        return this.m_58899_().m_252807_();
    }

    @Override
    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        ListTag receiverTag = pTag.m_128437_("Receivers", 10);
        this.receiverPositions.clear();
        for (int i = 0; i < receiverTag.size(); ++i) {
            this.receiverPositions.add(NbtUtils.m_129239_((CompoundTag)receiverTag.m_128728_(i)));
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        ListTag receiverTag = new ListTag();
        for (BlockPos pos : this.receiverPositions) {
            receiverTag.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        pTag.m_128365_("Receivers", (Tag)receiverTag);
    }
}

