/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.stormlightstorage;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.stormlightstorage.TransferenceConnectorBlock;
import us.amon.stormward.blockentity.stormlightstorage.StormlightTransferBlockEntity;

public class TransferenceConnectorEntity
extends BlockEntity {
    protected static final int TRANSFER_INTERVAL = 10;
    protected static final int TRANSFER_AMOUNT = 6;
    protected static final int PARTICLE_INTERVAL = 3;
    protected Set<BlockPos> connectorPositions = new HashSet<BlockPos>();
    protected boolean isActive;

    public TransferenceConnectorEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void setConnectors(Set<BlockPos> pConnectorPositions) {
        this.connectorPositions = pConnectorPositions;
    }

    public BlockPos getConnectedBlockPos() {
        return this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)TransferenceConnectorBlock.FACING));
    }

    public StormlightTransferBlockEntity getConnectedEntity() {
        if (this.m_58904_() != null) {
            BlockPos pos = this.getConnectedBlockPos();
            BlockEntity blockEntity = this.m_58904_().m_7702_(pos);
            if (blockEntity instanceof StormlightTransferBlockEntity) {
                StormlightTransferBlockEntity transferEntity = (StormlightTransferBlockEntity)blockEntity;
                return transferEntity;
            }
        }
        return null;
    }

    public boolean canExtractStormlight() {
        StormlightTransferBlockEntity connectedEntity = this.getConnectedEntity();
        return connectedEntity != null && connectedEntity.canExtractStormlight();
    }

    public boolean canReceiveStormlight() {
        StormlightTransferBlockEntity connectedEntity = this.getConnectedEntity();
        return connectedEntity != null && connectedEntity.canReceiveStormlight();
    }

    public void sendUpdate(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.m_5776_()) {
            this.m_6596_();
            pLevel.m_7260_(pPos, pState, pState, 3);
        }
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        ListTag connectorTag = pTag.m_128437_("Connectors", 10);
        this.connectorPositions.clear();
        for (int i = 0; i < connectorTag.size(); ++i) {
            this.connectorPositions.add(NbtUtils.m_129239_((CompoundTag)connectorTag.m_128728_(i)));
        }
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        ListTag connectorTag = new ListTag();
        for (BlockPos pos : this.connectorPositions) {
            connectorTag.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        pTag.m_128365_("Connectors", (Tag)connectorTag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("IsActive", this.isActive);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.isActive = tag.m_128471_("IsActive");
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, TransferenceConnectorEntity pBlockEntity) {
        pBlockEntity.tick(pLevel, pPos, pState);
    }

    protected void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_() && this.isActive) {
            this.playActiveEffects(pLevel, pPos, pState);
        }
    }

    protected void playActiveEffects(Level pLevel, BlockPos pPos, BlockState pState) {
    }

    protected Vec3 getRandomParticleOffset(Level pLevel, Direction pDirection) {
        double angle = (double)pLevel.f_46441_.m_188501_() * Math.PI * 2.0;
        if (pDirection.m_122429_() != 0) {
            return new Vec3(0.0, Math.cos(angle), Math.sin(angle)).m_82490_(0.5);
        }
        if (pDirection.m_122430_() != 0) {
            return new Vec3(Math.cos(angle), 0.0, Math.sin(angle)).m_82490_(0.5);
        }
        return new Vec3(Math.cos(angle), Math.sin(angle), 0.0).m_82490_(0.5);
    }
}

