/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.stormlightstorage;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.stormlightstorage.TransferenceStandBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.stormlightstorage.StormlightTransferBlockEntity;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightItemHandlerStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.entity.spren.overworld.SprenOverworld;
import us.amon.stormward.gemstone.IGemstoneProvider;
import us.amon.stormward.item.CagedGemItem;
import us.amon.stormward.sound.StormwardSoundEvents;

public class TransferenceStandEntity
extends StormlightTransferBlockEntity {
    public static final int SLOT = 0;
    private static final int SPREN_CHECK_INTERVAL = 40;
    private static final int SPREN_INTEREST_RADIUS = 8;
    private static final int SPREN_SPAWN_TRIES = 68;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TransferenceStandEntity.this.f_58857_ != null && TransferenceStandEntity.this.f_58857_.m_8055_(TransferenceStandEntity.this.m_58899_()).m_60713_((Block)StormwardBlocks.TRANSFERENCE_STAND.get())) {
                TransferenceStandEntity.this.sendUpdate();
            }
        }
    };
    private final LazyOptional<ItemStackHandler> optional = LazyOptional.of(() -> this.inventory);

    public TransferenceStandEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.TRANSFERENCE_STAND.get(), pPos, pBlockState);
    }

    @Override
    protected IStormlightStorage initStormlightStorage(BlockState pBlockState) {
        return new StormlightItemHandlerStorage((ICapabilityProvider)this);
    }

    @Override
    protected BlockState updateState(BlockState pState) {
        pState = super.updateState(pState);
        pState = this.updateProperty(pState, TransferenceStandBlock.LIT, this.isLit());
        pState = this.updateProperty(pState, TransferenceStandBlock.HAS_ITEM, this.hasItem());
        return pState;
    }

    public void setItem(ItemStack item) {
        this.inventory.setStackInSlot(0, item);
    }

    public ItemStack getItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean hasItem() {
        return !this.getItem().m_41619_();
    }

    public void popOutItem() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            BlockPos blockpos = this.m_58899_();
            ItemStack stack = this.getItem();
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            if (!stack.m_41619_()) {
                Vec3 vec3 = Vec3.m_272021_((Vec3i)blockpos, (double)0.5, (double)0.51, (double)0.5).m_272010_(this.f_58857_.f_46441_, 0.7f);
                ItemStack copy = stack.m_41777_();
                ItemEntity entity = new ItemEntity(this.f_58857_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), copy);
                entity.m_32060_();
                this.f_58857_.m_7967_((Entity)entity);
            }
        }
    }

    public boolean isLit() {
        return this.getItem().m_41720_() instanceof IGemstoneProvider && !StormlightStorageHelper.isDun((ICapabilityProvider)this.getItem());
    }

    @Override
    protected boolean serverTick(ServerLevel pLevel, BlockPos pPos, BlockState pState) {
        Item item;
        boolean result = super.serverTick(pLevel, pPos, pState);
        if ((pLevel.m_46467_() + pPos.m_121878_()) % 40L == 0L && (item = this.getItem().m_41720_()) instanceof CagedGemItem) {
            CagedGemItem gemItem = (CagedGemItem)item;
            EntityType<? extends SprenOverworld> sprenType = gemItem.getSprenType();
            List matchingSpren = pLevel.m_6443_(SprenOverworld.class, new AABB(pPos).m_82400_(8.0), spren -> spren.m_6095_() == sprenType);
            if (matchingSpren.isEmpty()) {
                SprenOverworld.addAroundBlock(sprenType, (Level)pLevel, pPos, 8, 68);
            } else if (matchingSpren.stream().noneMatch(spren -> pPos.equals((Object)spren.getInterestBlock()))) {
                ((SprenOverworld)((Object)matchingSpren.get(pLevel.f_46441_.m_188503_(matchingSpren.size())))).setInterestBlock(pPos);
            }
        }
        return result;
    }

    public void absorbSpren(Level pLevel, BlockPos pPos, SprenOverworld pSpren) {
        Item item = this.getItem().m_41720_();
        if (item instanceof CagedGemItem) {
            CagedGemItem gemItem = (CagedGemItem)item;
            this.setItem(gemItem.absorbSpren(this.getItem(), pSpren));
            this.sendUpdate();
            pLevel.m_247517_(null, pPos, (SoundEvent)StormwardSoundEvents.TRANSFERENCE_STAND_ABSORB.get(), SoundSource.BLOCKS);
        }
    }

    @Override
    public Vec3 getTransferPos() {
        return super.getTransferPos().m_82520_(0.0, 0.3125, 0.0);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory.deserializeNBT(pTag.m_128469_("Inventory"));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.optional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }
}

